/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.nodes;

import electric.soap.references.ISOAPReference;
import electric.soap.references.SOAPReferenceFactories;
import electric.util.Context;
import electric.util.XURL;
import electric.util.time.TimeUtil;

public class NodeInfo {
    private String url;
    private boolean gaiaIntermediary;
    private boolean gaiaServer;
    private boolean gaiaPersistence;
    private boolean online;
    private long since;
    private transient ISOAPReference soapReference;

    public NodeInfo() {
    }

    public NodeInfo(String url, boolean online, long since, boolean gaiaIntermediary, boolean gaiaServer, boolean gaiaPersistence) {
        this.url = url;
        this.gaiaIntermediary = gaiaIntermediary;
        this.gaiaServer = gaiaServer;
        this.gaiaPersistence = gaiaPersistence;
        this.online = online;
        this.since = since;
    }

    public NodeInfo(NodeInfo nodeInfo) {
        this.url = nodeInfo.url;
        this.gaiaIntermediary = nodeInfo.gaiaIntermediary;
        this.gaiaServer = nodeInfo.gaiaServer;
        this.gaiaPersistence = nodeInfo.gaiaPersistence;
        this.online = nodeInfo.online;
        this.since = nodeInfo.since;
    }

    public String toString() {
        return "NodeInfo( url=" + this.url + ", online=" + this.online + ", since=" + this.since + ", intermediary=" + this.gaiaIntermediary + ", server=" + this.gaiaServer + ", persistence=" + this.gaiaPersistence + " )";
    }

    public String getURL() {
        return this.url;
    }

    public void setOnline(boolean online) {
        this.online = online;
        this.since = TimeUtil.now();
    }

    public boolean isOnline() {
        return this.online;
    }

    public long getSince() {
        return this.since;
    }

    public void setSince(long since) {
        this.since = since;
    }

    public synchronized ISOAPReference getSOAPReference() {
        if (this.soapReference != null) {
            return this.soapReference;
        }
        try {
            Context context = new Context();
            XURL xurl = new XURL(this.url + "/fabric/nodeManager");
            this.soapReference = SOAPReferenceFactories.newSOAPReference(xurl, null, context);
        }
        catch (Exception exception) {}
        return this.soapReference;
    }
}

