/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.rules.processors.transform;

import electric.fabric.rules.conditions.IUnaryCondition;
import electric.xml.Document;
import electric.xml.Element;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;

public class XSLTTransform {
    private static transient TransformerFactory factory = TransformerFactory.newInstance();
    public Element xslt;
    public IUnaryCondition[] conditions;
    private transient Transformer transformer;

    public XSLTTransform() {
    }

    public XSLTTransform(Element xslt) {
        this(xslt, new IUnaryCondition[0]);
    }

    public XSLTTransform(Document xslt) {
        this(xslt.getRoot(), new IUnaryCondition[0]);
    }

    public XSLTTransform(Element xslt, IUnaryCondition[] conditions) {
        this.xslt = xslt;
        this.conditions = conditions;
    }

    public String toString() {
        return "XSLTTransform( xslt=" + this.xslt + " )";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Transformer getTransformer() throws TransformerException {
        if (this.transformer != null) {
            return this.transformer;
        }
        Document document = new Document(new Element(this.xslt));
        DOMSource source = new DOMSource(document);
        TransformerFactory transformerFactory = factory;
        synchronized (transformerFactory) {
            this.transformer = factory.newTransformer(source);
        }
        return this.transformer;
    }

    public synchronized Document transform(Document document) throws TransformerException {
        DOMSource input = new DOMSource(document);
        Document result = new Document();
        DOMResult output = new DOMResult(result);
        this.getTransformer().transform(input, output);
        return result;
    }
}

