/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.broker.locators.xdb;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.broker.BrokerInfo;
import electric.fabric.services.broker.IBrokerLocator;
import electric.fabric.services.broker.uddi.XDBUDDIServer;
import electric.util.Context;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xdb.Data;
import electric.xdb.Id;
import electric.xdb.server.LocalXDBServerFactory;
import electric.xdb.server.XDBServer;

public class XDBLocator
implements IBrokerLocator,
IFabricConstants,
ILoggingConstants {
    private String inquiryURL;
    private String publicationURL;
    private String adminURL;
    private String user;
    private String password;
    private String operatorName;
    private String businessName;

    public XDBLocator(String inquiryURL, String publicationURL, String adminURL, String user, String password, String operatorName, String businessName) {
        this.inquiryURL = inquiryURL;
        this.publicationURL = publicationURL;
        this.adminURL = adminURL;
        this.user = user;
        this.password = password;
        this.operatorName = operatorName;
        this.businessName = businessName;
    }

    public BrokerInfo getBrokerInfo() {
        block3: {
            if (Fabric.isClient()) {
                return null;
            }
            try {
                Context context = new Context();
                context.setProperty("first", "true");
                XDBUDDIServer uddiServer = new XDBUDDIServer(this.inquiryURL, this.publicationURL, this.adminURL, this.user, this.password, this.operatorName, this.businessName);
                Data data = new Data(new Id("broker", 1000L), (Object)uddiServer);
                LocalXDBServerFactory.getServer("services", XDBServer.getDefaultReplicationFactor(), new String[0], context, new Data[]{data}, false);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "error during XDBLocator.getBrokerInfo()", exception);
            }
        }
        return Fabric.getServiceManager().getBrokerInfo();
    }
}

