/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.liveness;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.logs.LogEntry;
import electric.fabric.logs.LogManagerException;
import electric.fabric.services.ServiceInfo;
import electric.soap.SOAPMessage;
import electric.soap.references.ISOAPReference;
import electric.util.Context;
import electric.util.thread.ThreadPool;
import electric.util.time.TimeUtil;
import electric.xdb.IActiveData;
import electric.xdb.IXDBConstants;
import electric.xdb.server.IXDBServer;
import java.rmi.RemoteException;

public class ServiceLiveness
implements IActiveData,
Runnable,
IFabricConstants,
IXDBConstants {
    private static long livenessCycle = 30000L;
    private static long reapThreshold = 100000L;
    private static final SOAPMessage ping = ServiceLiveness.getPingMessage();
    private transient boolean stop;
    private transient long currentTime;
    private transient long lastTime;

    public static void setReapThreshold(long reapThreshold) {
        ServiceLiveness.reapThreshold = reapThreshold;
    }

    public static long getReapThreshold() {
        return reapThreshold;
    }

    public boolean isMany() {
        return false;
    }

    public void activate(IXDBServer server) {
        ThreadPool.getShared().run(this);
    }

    public void deactivate(IXDBServer server) {
        this.stop = true;
    }

    public static void setLivenessCycle(long milliseconds) {
        livenessCycle = milliseconds;
    }

    public static long getLivenessCycle() {
        return livenessCycle;
    }

    public void run() {
        this.stop = false;
        while (!this.stop) {
            this.checkLiveness();
            try {
                Thread.sleep(livenessCycle);
            }
            catch (InterruptedException exception) {
                // empty catch block
            }
        }
    }

    private void checkLiveness() {
        try {
            Fabric.getLogManager().addLogEntry(new LogEntry("Ping Services for Liveness", "SYSTEM"));
        }
        catch (LogManagerException exception) {
            // empty catch block
        }
        try {
            this.currentTime = TimeUtil.now();
            ServiceInfo[] serviceInfo = Fabric.getServiceManager().getAllServiceInfo();
            int i = 0;
            while (i < serviceInfo.length) {
                this.checkService(serviceInfo[i]);
                ++i;
            }
            this.lastTime = this.currentTime;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkService(ServiceInfo serviceInfo) {
        if (serviceInfo.isOnline()) {
            this.checkOnlineService(serviceInfo);
        } else {
            this.checkOfflineService(serviceInfo);
        }
    }

    private void ping(ServiceInfo serviceInfo) throws Exception {
        ISOAPReference soapReference = serviceInfo.getSOAPReference();
        Context messageContext = new Context();
        soapReference.handle(ping, messageContext);
    }

    private boolean shouldPing(ServiceInfo serviceInfo) {
        long time = serviceInfo.getSince();
        int cycles = 1;
        while (time + livenessCycle * (long)cycles <= this.currentTime) {
            time += livenessCycle * (long)cycles;
            cycles *= 2;
        }
        return time > this.lastTime;
    }

    private void checkOnlineService(ServiceInfo serviceInfo) {
        try {
            this.ping(serviceInfo);
        }
        catch (RemoteException exception) {
            this.updateData(serviceInfo, false);
        }
        catch (Exception exception) {}
    }

    private void checkOfflineService(ServiceInfo serviceInfo) {
        block4: {
            block3: {
                if (this.currentTime - serviceInfo.getSince() <= reapThreshold) break block3;
                this.unpublish(serviceInfo);
                break block4;
            }
            if (!this.shouldPing(serviceInfo)) break block4;
            try {
                this.ping(serviceInfo);
                this.updateData(serviceInfo, true);
            }
            catch (RemoteException exception) {
            }
            catch (Exception exception) {}
        }
    }

    private void unpublish(ServiceInfo serviceInfo) {
        try {
            Fabric.getServiceManager().unpublishUsingEndpoint(serviceInfo.getEndpoint());
        }
        catch (Exception exception) {}
    }

    private void updateData(ServiceInfo serviceInfo, boolean online) {
        try {
            ServiceInfo newServiceInfo = new ServiceInfo(serviceInfo);
            newServiceInfo.setOnline(online);
            Fabric.getServiceManager().publishUsingInfo(newServiceInfo);
        }
        catch (Exception exception) {}
    }

    private static SOAPMessage getPingMessage() {
        SOAPMessage ping = new SOAPMessage();
        ping.addMIMEHeader("SOAPAction", "\"\"");
        ping.addBody().addElement("livenessPing");
        return ping;
    }
}

