/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.enterprise.config;

import electric.cluster.IClusterConstants;
import electric.cluster.lifecycle.LifecycleCommandFactory;
import electric.cluster.server.ApplicationServer;
import electric.glue.IGLUELoggingConstants;
import electric.glue.enterprise.config.IConfigConstants;
import electric.util.Context;
import electric.util.file.FileUtil;
import electric.util.log.Log;
import electric.util.path.PathUtil;
import electric.util.product.IConfig;
import electric.util.string.Strings;
import electric.xml.Element;

public class AppConfig
implements IConfig,
IConfigConstants,
IClusterConstants {
    public void config(Element config) throws Throwable {
        boolean multiVM = true;
        String applicationHome = Context.getSystemProperty("glue.apphome");
        String isMaster = Context.getSystemProperty("glue.master");
        boolean master = Strings.getBoolean(isMaster, false);
        if (applicationHome == null || applicationHome.equals(".\\")) {
            applicationHome = FileUtil.currentDirectoryPath();
        }
        if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)("application home is " + applicationHome));
        }
        ApplicationServer.setApplicationsRoot(PathUtil.normalizeSlashes(applicationHome));
        ApplicationServer.setMaster(master);
        LifecycleCommandFactory.setMultiVM(multiVM);
        LifecycleCommandFactory.setMaster(master);
    }
}

