/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.config;

import electric.application.Applications;
import electric.console.ConsoleServlet;
import electric.console.handlers.IConsoleHandler;
import electric.console.services.ConsoleFacade;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ServiceContext;
import electric.glue.pro.config.IConfigConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.IServer;
import electric.server.Servers;
import electric.util.Context;
import electric.util.XURL;
import electric.util.classloader.ClassLoaders;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Hashtable;

public class ConsoleConfig
implements IConfigConstants,
IGLUELoggingConstants {
    private static boolean featureUseEnabled = false;
    private static boolean allowFeatureReEnable = true;
    private static boolean consoleBackEndEnabled = false;
    private static Document layoutDocument = null;
    private static Hashtable consoleProducts = new Hashtable();
    static /* synthetic */ Class class$electric$application$IApplication;

    public static void enable() {
        if (featureUseEnabled) {
            return;
        }
        if (!allowFeatureReEnable) {
            throw new IllegalStateException("Console cannot be enabled once it is disabled");
        }
        featureUseEnabled = Enabler.enable();
    }

    public static boolean isEnabled() {
        return consoleBackEndEnabled;
    }

    public static void disable() {
        featureUseEnabled = false;
        allowFeatureReEnable = false;
    }

    public void config(Element config, boolean simpleApp) {
        Element consoleElement = config.getElement("console");
        boolean consoleUserEnabled = Strings.getBoolean(Context.getSystemProperty("glue.console"), false);
        if (consoleElement == null) {
            return;
        }
        boolean consoleEnabledInConfig = false;
        try {
            if (consoleElement.hasElement("enabled")) {
                consoleEnabledInConfig = consoleElement.getBoolean("enabled");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!consoleUserEnabled && !consoleEnabledInConfig) {
            return;
        }
        consoleBackEndEnabled = true;
        this.initLayoutDoc(consoleElement);
        ConsoleConfig.registerConsoleProducts(consoleElement);
        this.registerHandlers(consoleElement);
        if (simpleApp) {
            this.enableConsole();
        }
    }

    private static void registerConsoleProducts(Element consoleConfig) {
        Elements productElements = consoleConfig.getElements("product");
        while (productElements.hasMoreElements()) {
            ConsoleConfig.registerConsoleProduct(productElements.next());
        }
    }

    private static void registerConsoleProduct(Element productElement) {
        String productName = productElement.getAttribute("productName");
        consoleProducts.put(productName, productElement);
    }

    public static void addConsoleModule(String productName) {
        Element productElement = (Element)consoleProducts.get(productName);
        if (productElement == null) {
            return;
        }
        String swfURL = productElement.getAttribute("detailsPanelURL");
        String helpFileURL = productElement.getAttribute("helpFileURL");
        String serviceURL = productElement.getAttribute("serviceURL");
        String treeLabel = productElement.getAttribute("treeLabel");
        String consoleService = productElement.getAttribute("consoleService");
        ConsoleFacade.registerProduct(productName, treeLabel, consoleService, swfURL, serviceURL, helpFileURL);
        Elements modules = productElement.getElements("module");
        while (modules.hasMoreElements()) {
            Element module = modules.next();
            if (!module.hasElement("consoleService")) continue;
            String title = module.getString("title");
            String moduleClass = module.getString("consoleService");
            swfURL = module.getString("detailsPanelURL");
            serviceURL = module.getString("serviceURL");
            String helpfileURL = module.getString("helpFileURL");
            if (title == null) {
                title = moduleClass;
            }
            try {
                ConsoleFacade.registerConsoleModule(productName, title, moduleClass, swfURL, serviceURL, helpfileURL);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to register console module due to exception. module class name " + moduleClass, exception);
            }
        }
    }

    private void registerHandlers(Element consoleElement) {
        Elements handlers = consoleElement.getElements("handler");
        while (handlers.hasMoreElements()) {
            Element handler = handlers.next();
            String handlerPath = handler.getString();
            try {
                Class handlerClass = ClassLoaders.loadClass(handlerPath);
                IConsoleHandler consoleHandler = (IConsoleHandler)handlerClass.newInstance();
                ConsoleServlet.addConsoleHandler(consoleHandler);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to register console handler due to exception. handler class name " + handlerPath, exception);
            }
        }
    }

    private void enableConsole() {
        block2: {
            try {
                this.publishApplicationService();
                this.publishConsoleServices();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block2;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to enable console due to exception", exception);
            }
        }
    }

    private void publishApplicationService() throws RegistryException {
        ServiceContext context = new ServiceContext();
        context.addXMLInclude("electric.util.constructor.Factory");
        context.addXMLInclude("electric.util.constructor.Constructor");
        Registry.publish("system/application", (Object)Applications.getDefaultApplication(), class$electric$application$IApplication == null ? (class$electric$application$IApplication = ConsoleConfig.class$("electric.application.IApplication")) : class$electric$application$IApplication, (Context)context);
    }

    private void publishConsoleServices() throws RegistryException {
        Registry.publish("system/console", new ConsoleFacade());
    }

    private synchronized void initLayoutDoc(Element consoleConfig) {
        Elements configElements = consoleConfig.getElements();
        layoutDocument = new Document();
        Element root = layoutDocument.setRoot("ConsoleConfig");
        while (configElements.hasMoreElements()) {
            root.addElement(new Element(configElements.next()));
        }
        IServer[] servers = Servers.getServersForProtocol("http");
        if (servers.length > 0) {
            XURL xurl = servers[0].getPath();
            root.setText("url", xurl.toString());
        }
    }

    public static Document getLayoutDocument() {
        return layoutDocument;
    }

    public static void mergeLayoutDocument(Element root) {
        if (layoutDocument == null) {
            return;
        }
        ConsoleConfig.registerConsoleProducts(root);
        Elements elements = root.getElements();
        while (elements.hasMoreElements()) {
            layoutDocument.getRoot().addChild(elements.next());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

