/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.config;

import electric.glue.pro.config.IConfigConstants;
import electric.soap.security.signature.xml.canonical.CanonicalizerFactories;
import electric.soap.security.signature.xml.canonical.ICanonicalizerFactory;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.xml.Element;
import electric.xml.Elements;

public class XMLCanonicalizationConfig
implements IConfig,
IConfigConstants,
ILoggingConstants {
    public void config(Element config) throws Throwable {
        Element canonicalizationConfig = config.getElement("xmlCanonicalization");
        if (canonicalizationConfig == null) {
            return;
        }
        this.configCanonicalizerFactories(canonicalizationConfig);
    }

    private void configCanonicalizerFactories(Element config) throws Throwable {
        Elements factories = config.getElements("factory");
        while (factories.hasMoreElements()) {
            Element factoryElement = factories.next();
            String factoryClassName = factoryElement.getString("class");
            String id = factoryElement.getString("id");
            try {
                Class factoryClass = ClassLoaders.loadClass(factoryClassName);
                CanonicalizerFactories.addFactory(id, (ICanonicalizerFactory)factoryClass.newInstance());
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)("could not load Canonicalizer Factory " + exception.toString()));
            }
        }
    }
}

