/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.config;

import electric.glue.pro.config.IConfigConstants;
import electric.soap.security.encryption.xml.crypto.EncryptionAlgorithms;
import electric.soap.security.encryption.xml.crypto.IEncryptionAlgorithm;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.xml.Element;
import electric.xml.Elements;

public class XMLEncryptionConfig
implements IConfig,
IConfigConstants,
ILoggingConstants {
    public void config(Element config) throws Throwable {
        Element encryptionConfig = config.getElement("xmlEncryption");
        if (encryptionConfig == null) {
            return;
        }
        this.configEncryptionAlgorithms(encryptionConfig);
    }

    private void configEncryptionAlgorithms(Element config) throws Throwable {
        Elements algorithms = config.getElements("encryptionAlgorithm");
        while (algorithms.hasMoreElements()) {
            Element algorithm = algorithms.next();
            String algorithmId = algorithm.getString("id");
            String algorithmClassName = algorithm.getString("class");
            try {
                Class algorithmClass = ClassLoaders.loadClass(algorithmClassName);
                IEncryptionAlgorithm encryptionAlgorithm = (IEncryptionAlgorithm)algorithmClass.newInstance();
                EncryptionAlgorithms.registerEncryptionAlgorithm(algorithmId, encryptionAlgorithm);
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)("could not load xml encryption algorithm " + exception.toString()));
            }
        }
    }
}

