/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.console.services;

import electric.application.Applications;
import electric.application.DeploymentException;
import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.console.util.ConsoleNodeWriter;
import electric.directory.DirectoryException;
import electric.directory.IDirectory;
import electric.glue.pro.console.services.IServicesConstants;
import electric.registry.IRegistry;
import electric.registry.IRegistryListener;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.service.IActivationConstants;
import electric.service.IService;
import electric.service.descriptor.ServiceDescriptor;
import electric.service.ejb.StatelessSessionBeanService;
import electric.service.instrumentation.Instrumentor;
import electric.service.object.ObjectService;
import electric.service.virtual.VirtualService;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.handlers.SOAPHandlerFactories;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.SOAPOperation;
import electric.util.Context;
import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.context.IContextHolder;
import electric.util.java.JavaNames;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.Reflect;
import electric.wsdl.Operations;
import electric.wsdl.WSDL;
import electric.xml.CData;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class Services
implements IRegistryListener,
ILoggingConstants,
IConsoleModule,
ITreeViewProducer,
IServicesConstants,
IConsoleConstants {
    private static final int MAX_MOST_ACTIVES = 3;
    private int javaObjectServices = 0;
    private int ejbObjectServices = 0;
    private int virtualObjectServices = 0;
    private int applicationActivation = 0;
    private int sessionActivation = 0;
    private int requestActivation = 0;
    private Hashtable pathToInstrumentor = new Hashtable();
    private Hashtable registryListeners = new Hashtable();
    private ConsoleModuleInfo moduleInfo;
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPBinding;

    public Services() {
        Registry.addListener("registryMonitor", this);
        try {
            this.scan("/", Registry.getDirectory("/"), true);
        }
        catch (Exception exception) {}
    }

    public Document getServicesInfo() {
        Document doc;
        block3: {
            doc = new Document();
            try {
                Element root = doc.setRoot("DataUpdate");
                Element services = root.addElement("Services");
                int totalServices = this.javaObjectServices + this.ejbObjectServices + this.virtualObjectServices;
                services.setText("Total", totalServices + "");
                Element mostActive = services.addElement("MostActive");
                String[] mostActiveServices = this.getMostActive();
                int i = 0;
                while (i < mostActiveServices.length) {
                    mostActive.addElement("Service").setText(mostActiveServices[i]);
                    ++i;
                }
                services.setText("JavaServices", this.javaObjectServices + "");
                services.setText("EJB", this.ejbObjectServices + "");
                services.setText("Virtual", this.virtualObjectServices + "");
                services.setText("TotalApplication", this.applicationActivation + "");
                services.setText("TotalSession", this.sessionActivation + "");
                services.setText("TotalRequest", this.requestActivation + "");
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to create service summary for ", exception);
            }
        }
        return doc;
    }

    public Document getServiceInfo(Hashtable args) {
        String servicePath = (String)args.get("servicePath");
        try {
            String wsdlTargetNamespace;
            Context context;
            IService service;
            Element root;
            Document doc;
            block8: {
                Object obj = Registry.get(servicePath);
                doc = new Document(new Element("ServiceDetails"));
                root = doc.getRoot();
                if (!(obj instanceof IService)) {
                    return null;
                }
                service = (IService)obj;
                context = service.getContext();
                String activation = (String)context.getProperty("activation");
                if (activation == null) {
                    activation = IActivationConstants.modes[0];
                }
                root.setText("activation", activation);
                root.setText("status", "enabled");
                root.setText("style", (String)context.getProperty("style", "rpc"));
                WSDL wsdl = service.getWSDL();
                wsdlTargetNamespace = "";
                try {
                    wsdlTargetNamespace = wsdl.getTargetNamespace();
                }
                catch (Exception e) {
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block8;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Object)("unable to retrieve wsdl target namespace for  " + servicePath));
                }
            }
            root.setText("wsdlTargetNamespace", wsdlTargetNamespace);
            root.setText("methodNamespace", context.getStringProperty("namespace", "x"));
            root.setText("description", context.getStringProperty("description", "no description"));
            root.setText("soapAction", context.getStringProperty("soapAction", "varies per method"));
            if (!wsdlTargetNamespace.equals("")) {
                this.addMethods(root, service);
            }
            return doc;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to create service summary for " + servicePath, exception);
            }
            return new Document();
        }
    }

    public Document publishService(Hashtable args) {
        Document response = new Document(new Element("PublishStatus"));
        try {
            Document requestDoc = new Document((String)args.get("request"));
            String publishPath = requestDoc.getRoot().removeElement("publishPath").getString();
            ServiceDescriptor descriptor = new ServiceDescriptor(requestDoc);
            Applications.getDefaultApplication().addServiceUsingDescriptor(publishPath, descriptor);
        }
        catch (ParseException exception) {
            response.getRoot().addElement("statusCode").setInt(100);
            response.getRoot().addElement("errorMessage").setText(exception.toString());
            return response;
        }
        catch (DeploymentException exception) {
            response.getRoot().addElement("statusCode").setInt(200);
            response.getRoot().addElement("errorMessage").setText(exception.toString());
            return response;
        }
        response.getRoot().addElement("statusCode").setInt(0);
        return response;
    }

    public String unpublishService(Hashtable args) {
        try {
            Registry.unpublish((String)args.get("servicePath"));
        }
        catch (RegistryException exception) {
            return "unpublishStatus=" + exception.toString();
        }
        return "";
    }

    public String handleInvoke(Hashtable arg) throws IOException {
        SOAPMessage requestObj = null;
        SOAPMessage soapResponse = null;
        Value responseValue = null;
        Document response = new Document();
        try {
            Document doc = new Document((String)arg.get("request"));
            String servicePath = doc.getRoot().getTextString("servicePath");
            String methodName = doc.getRoot().getTextString("methodName");
            String endpoint = doc.getRoot().getTextString("endpoint");
            Elements args = doc.getRoot().getElements("argument");
            boolean tagSubstitution = doc.getRoot().hasElement("tagSubstitution");
            boolean hrefInlining = doc.getRoot().hasElement("hrefInlining");
            boolean omitEnvelope = doc.getRoot().hasElement("omitEnvelope");
            Object[] arguments = null;
            if (args.size() == 1 && !args.first().hasChildNodes()) {
                arguments = new String[]{};
            } else {
                arguments = new String[args.size()];
                int i = 0;
                while (args.hasMoreElements()) {
                    String str = args.next().getTextString();
                    if (str != null) {
                        arguments[i] = URLDecoder.decode(str);
                    }
                    ++i;
                }
            }
            IService service = (IService)Registry.get(servicePath);
            WSDL wsdl = service.getWSDL();
            Operations operations = wsdl.getOperationsForBindingClass(class$electric$soap$wsdl$SOAPBinding == null ? (class$electric$soap$wsdl$SOAPBinding = Services.class$("electric.soap.wsdl.SOAPBinding")) : class$electric$soap$wsdl$SOAPBinding);
            SOAPOperation operation = (SOAPOperation)operations.getOperation(methodName, arguments.length);
            requestObj = new SOAPMessage();
            SOAPOptimizations optimizations = new SOAPOptimizations();
            optimizations.setTagSubstitution(tagSubstitution);
            optimizations.setHrefInlining(hrefInlining);
            optimizations.setEnvelopeOmission(omitEnvelope);
            Class[] types = operation.getArgClasses();
            Object[] argObjects = new Object[arguments.length];
            int i = 0;
            while (i < arguments.length) {
                argObjects[i] = Reflect.valueOf(arguments[i], types[i]);
                ++i;
            }
            operation.writeRequest(requestObj, optimizations, argObjects);
            ISOAPHandler handlerChain = SOAPHandlerFactories.getSOAPHandlerChain(service);
            Context messageContext = new Context();
            messageContext.setProperty("endpoint", endpoint);
            soapResponse = handlerChain.handle(requestObj, messageContext);
            responseValue = operation.readResponse(soapResponse, arguments);
        }
        catch (Throwable exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "got exception during method invocation processing", exception);
            }
            soapResponse = new SOAPMessage();
            soapResponse.setException(exception);
        }
        Element root = response.setRoot("invocaionResult");
        String result = responseValue != null ? (responseValue.getObject() == null ? "null" : responseValue.getObject().toString()) : "ERROR";
        root.addElement("result").setText(result);
        StringWriter writer = new StringWriter();
        ConsoleNodeWriter consoleWriter = new ConsoleNodeWriter(writer, 2, false, 2, "\r");
        requestObj.getDocument().write(consoleWriter);
        root.addElement("soapRequest").setText(new CData(writer.toString()));
        writer = new StringWriter();
        consoleWriter = new ConsoleNodeWriter(writer, 2, false, 2, "\r");
        soapResponse.getDocument().write(consoleWriter);
        root.addElement("soapResponse").setText(new CData(writer.toString()));
        return response.toString();
    }

    private void addMethods(Element root, IService service) throws Exception {
        Element methods = root.addElement("methods");
        WSDL wsdl = service.getWSDL();
        Instrumentor instrumentor = (Instrumentor)service.getContext().getProperty("instrumentor");
        SOAPOperation[] operations = ((SOAPBinding)wsdl.getBindings(class$electric$soap$wsdl$SOAPBinding == null ? (class$electric$soap$wsdl$SOAPBinding = Services.class$("electric.soap.wsdl.SOAPBinding")) : class$electric$soap$wsdl$SOAPBinding)[0]).getSOAPOperations();
        if (instrumentor != null) {
            Element stats = root.addElement("stats");
            stats.setText("totalSuccesses", instrumentor.getTotalSuccesses() + "");
            stats.setText("totalFailures", instrumentor.getTotalFailures() + "");
        }
        int i = 0;
        while (i < operations.length) {
            SOAPOperation operation = operations[i];
            String methodName = operation.getOperation().getName();
            String documentation = operation.getOperation().getDocumentation();
            Element method = methods.addElement("method");
            method.setText("name", methodName);
            method.setText("description", documentation);
            method.setText("soapAction", operation.getSOAPAction());
            if (instrumentor != null) {
                int args = operation.getMethod().getParameterTypes().length;
                method.setText("fastest", instrumentor.getFastestExecution(methodName, args) + "");
                method.setText("slowest", instrumentor.getSlowestExecution(methodName, args) + "");
                method.setText("average", instrumentor.getAverageExecution(methodName, args) + "");
                method.setText("last", instrumentor.getLastExecution(methodName, args) + "");
                method.setText("total", instrumentor.getTotalExecutions(methodName, args) + "");
            }
            if (operation.parameters.length != 0) {
                int k = 0;
                while (k < operation.parameters.length) {
                    Element argument = method.addElement("argument");
                    String name = operation.parameters[k].getName();
                    String javaName = JavaNames.getShortJavaName(operation.parameters[k].getJavaClass());
                    argument.setText("name", name);
                    argument.setText("javaName", javaName);
                    ++k;
                }
            }
            ++i;
        }
    }

    private void resetServiceCounters() {
        this.javaObjectServices = 0;
        this.ejbObjectServices = 0;
        this.virtualObjectServices = 0;
        this.applicationActivation = 0;
        this.sessionActivation = 0;
        this.requestActivation = 0;
    }

    private String[] getMostActive() {
        Long[] mostActive = new Long[]{};
        String[] mostActivePaths = new String[]{};
        long min = Long.MAX_VALUE;
        Enumeration enumeration = this.pathToInstrumentor.keys();
        while (enumeration.hasMoreElements()) {
            String path = (String)enumeration.nextElement();
            Instrumentor instrumentor = (Instrumentor)this.pathToInstrumentor.get(path);
            long totalRequests = instrumentor.getTotalRequests();
            if (mostActive.length < 3) {
                if (totalRequests <= 0L) continue;
                mostActive = (Long[])ArrayUtil.addElement(mostActive, new Long(totalRequests));
                mostActivePaths = (String[])ArrayUtil.addElement(mostActivePaths, path);
                min = Math.min(min, totalRequests);
                continue;
            }
            if (totalRequests <= min) continue;
            long newMin = Long.MAX_VALUE;
            int i = 0;
            while (i < 3) {
                if (mostActive[i] == min) {
                    mostActive[i] = new Long(totalRequests);
                    mostActivePaths[i] = path;
                }
                newMin = Math.min(newMin, mostActive[i]);
                ++i;
            }
            min = newMin;
        }
        return mostActivePaths;
    }

    private void cacheInstrumentor(String path, Object object) {
        if (!(object instanceof IContextHolder)) {
            return;
        }
        Context serviceContext = ((IContextHolder)object).getContext();
        Instrumentor instrumentor = (Instrumentor)serviceContext.getProperty("instrumentor");
        if (instrumentor != null) {
            this.pathToInstrumentor.put(path, instrumentor);
        }
    }

    private void updateServiceCounter(Object object, boolean objectAdded) {
        int counter;
        int n = counter = objectAdded ? 1 : -1;
        if (object instanceof ObjectService) {
            this.javaObjectServices += counter;
            int mode = ((ObjectService)object).getMode();
            if (mode == 0) {
                this.applicationActivation += counter;
            } else if (mode == 2) {
                this.sessionActivation += counter;
            } else if (mode == 1) {
                this.requestActivation += counter;
            }
        } else if (object instanceof VirtualService) {
            this.virtualObjectServices += counter;
        } else if (object instanceof StatelessSessionBeanService) {
            this.ejbObjectServices += counter;
        }
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        if (!this.registryListeners.containsKey(sessionID)) {
            Element registryXml;
            Element[] moduleHolder;
            block3: {
                moduleHolder = new Element[]{new Element("TREE")};
                moduleHolder[0].setAttribute("Name", "Services");
                moduleHolder[0].setAttribute("Function", "showDetails");
                moduleHolder[0].setAttribute("Params", "Services");
                moduleHolder[0].setAttribute("TARGET", "_root");
                moduleHolder[0].setAttribute("Path", "GLUE/Services");
                moduleHolder[0].setAttribute("ServiceID", "Services");
                moduleHolder[0].setAttribute("ModuleFunction", "showOverview");
                moduleHolder[0].setAttribute("swfURL", this.moduleInfo.getSWFURL());
                moduleHolder[0].setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
                moduleHolder[0].setAttribute("serviceURL", this.moduleInfo.getServiceURL());
                registryXml = new Element();
                this.pathToInstrumentor.clear();
                try {
                    this.resetServiceCounters();
                    IDirectory dir = Registry.getDirectory("/");
                    registryXml = this.scan("/", dir, true);
                    registryXml.setAttribute("Name", "Registry");
                }
                catch (DirectoryException exception) {
                    if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block3;
                    Log.log(ILoggingConstants.ERROR_EVENT, "unable to scan GLUE registry", exception);
                }
            }
            this.registryListeners.put(sessionID, new Element("Update"));
            moduleHolder[0].addChild(registryXml);
            return moduleHolder;
        }
        Element[] element = new Element[]{(Element)this.registryListeners.get(sessionID)};
        this.registryListeners.put(sessionID, new Element("Update"));
        return element;
    }

    private synchronized Element scan(String path, IDirectory dir, boolean createXML) throws DirectoryException {
        Element element = null;
        if (createXML) {
            element = new Element("TREE");
            this.setAttributes(element, this.getFolderName(path, 1), path);
            element.setAttribute("HeaderText", "Services");
            element.removeAttribute("customIcon");
        }
        Enumeration keys = dir.keys();
        Hashtable<String, String> directories = new Hashtable<String, String>();
        String[] elementKeys = new String[]{};
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object object = dir.get(key);
            if (object instanceof IDirectory) {
                directories.put(key, path + key + "/");
                continue;
            }
            if (createXML) {
                Element serviceElement = element.addElement("TREE").setText(key);
                this.setAttributes(serviceElement, key, path + key + "/");
                serviceElement.setAttribute("Params", "Services," + path + key + "/");
                serviceElement.setAttribute("customIcon", "ftree_icon_ws");
                elementKeys = (String[])ArrayUtil.addElement(elementKeys, key);
            }
            this.cacheInstrumentor(path + key, object);
            this.updateServiceCounter(object, true);
        }
        element.setAttribute("Params", "Services,folderPath," + path);
        element.setAttribute("ModuleFunction", "showPathDetails");
        Enumeration dirs = directories.keys();
        while (dirs.hasMoreElements()) {
            String key = (String)dirs.nextElement();
            String newPath = (String)directories.get(key);
            IDirectory directoryObject = (IDirectory)dir.get(key);
            Element node = this.scan(newPath, directoryObject, createXML);
            if (!createXML) continue;
            node.insertText(key);
            element.addElement(node);
        }
        return element;
    }

    private void setAttributes(Element element, String name, String path) {
        element.setAttribute("Name", name);
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("customIcon", "ftree_icon_ws");
        element.setAttribute("Path", path);
        element.setAttribute("ServiceID", "Services");
        element.setAttribute("ModuleFunction", "showNode");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
    }

    public void published(IRegistry registry, String path, Object object, Context context) {
        this.cacheInstrumentor(path, object);
        this.updateServiceCounter(object, true);
        Enumeration keys = this.registryListeners.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Element myObject = (Element)this.registryListeners.get(key);
            Element add = myObject.getRoot().addElement("Add");
            String folderName = this.getFolderName(path, 0);
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            add.setAttribute("Name", folderName);
            add.setAttribute("Function", "showDetails");
            add.setAttribute("Params", "Services," + path);
            add.setAttribute("TARGET", "_root");
            add.setAttribute("Path", "GLUE/Services/Registry" + path);
            add.setAttribute("ToDo", "add");
            add.setAttribute("pathFunction", "showPathDetails");
            add.setAttribute("customIcon", "ftree_icon_ws");
            add.setAttribute("ModuleFunction", "showNode");
            add.setAttribute("swfURL", this.moduleInfo.getSWFURL());
            add.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
            add.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
            add.setText(path);
        }
    }

    public void unpublished(IRegistry registry, String path, Object object) {
        this.pathToInstrumentor.remove(path);
        this.updateServiceCounter(object, false);
        Enumeration keys = this.registryListeners.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Element myObject = (Element)this.registryListeners.get(key);
            Element remove = myObject.getRoot().addElement("Remove");
            String folderName = this.getFolderName(path, 0);
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            remove.setAttribute("Name", folderName);
            remove.setAttribute("Function", "showDetails");
            remove.setAttribute("Params", "Services," + path);
            remove.setAttribute("TARGET", "_root");
            remove.setAttribute("Path", "GLUE/Services/Registry" + path);
            remove.setAttribute("ToDo", "remove");
            remove.setText(path);
        }
    }

    private String getFolderName(String path, int endPoint) {
        int pathLength;
        int whereAt = path.indexOf("/");
        String folderName = path;
        if (whereAt != -1 && (folderName = path.substring(0, (pathLength = path.length()) - endPoint)).indexOf("/") != -1) {
            whereAt = folderName.lastIndexOf("/");
            pathLength = folderName.length();
            folderName = folderName.substring(whereAt + 1, pathLength);
        }
        return folderName;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public boolean isSessionAware() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

