/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.std.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.security.IRealm;
import electric.security.Realms;
import electric.servlet.HTTPContext;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.xml.Element;
import electric.xml.Elements;

public final class RealmsConfig
implements IConfig,
IConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) {
        Element realmsElement = config.getElement("realms");
        if (realmsElement == null) {
            return;
        }
        Elements realms = realmsElement.getElements("realm");
        while (realms.hasMoreElements()) {
            Element realmElement = realms.next();
            try {
                IRealm realm = (IRealm)Creator.newInstance(realmElement, null);
                Realms.addRealm(realm);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) continue;
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("could not materialize realm " + realmElement + "\n" + throwable.toString()));
            }
        }
        String defaultRealm = realmsElement.getString("defaultRealm");
        HTTPContext.setDefaultRealm(defaultRealm);
    }
}

