/*
 * Decompiled with CFR 0.152.
 */
package electric.http;

import electric.glue.IGLUELoggingConstants;
import electric.http.HTTPMessage;
import electric.http.OutboundHTTPRequest;
import electric.http.cookies.ClientCookie;
import electric.http.cookies.ClientCookies;
import electric.net.channel.IChannel;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.encoding.StringEncodings;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.io.ChunkedInputStream;
import electric.util.io.Streams;
import electric.util.mime.MIMEHeaders;
import electric.util.string.Tokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public final class InboundHTTPResponse
implements IHTTPConstants,
IGLUELoggingConstants {
    private IChannel channel;
    private String version;
    private int status;
    private String message;
    private HTTPMessage httpMessage;
    private MIMEHeaders headers = new MIMEHeaders();

    public InboundHTTPResponse(OutboundHTTPRequest request) {
        this.channel = request.getChannel();
    }

    public InboundHTTPResponse(HTTPMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.channel = httpMessage.getChannel();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.version).append(' ').append(this.status).append(' ');
        buffer.append(this.message).append('\n').append(this.headers.toString());
        return buffer.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isOK() {
        return this.status == 200;
    }

    public XURL getHost() {
        return this.httpMessage.getHost();
    }

    public void readHeaders() throws IOException {
        String token;
        InputStream stream = this.channel.getInputStream();
        String command = Streams.readLine(stream, StringEncodings.getProtocolEncoding());
        if (command == null) {
            throw new IOException("input stream broken");
        }
        command = command.trim();
        Tokenizer tokenizer = new Tokenizer(command);
        this.version = token = tokenizer.nextToken();
        this.status = Integer.parseInt(tokenizer.nextToken());
        tokenizer.skipWhitespace();
        this.message = tokenizer.getRemainder();
        this.headers.readHeaders(stream);
        if (this.status == 100) {
            this.clearHeaders();
            this.readHeaders();
        }
    }

    public void clearHeaders() {
        this.headers.clearHeaders();
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    public int getIntHeader(String name) {
        return this.headers.getIntHeader(name);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    public int getContentLength() {
        return this.headers.getContentLength();
    }

    public String getContentType() {
        return this.headers.getContentType();
    }

    public boolean isKeepAlive() {
        return HTTPUtil.isKeepAlive(this.getHeader("Connection"), this.getVersion());
    }

    public ClientCookie[] getCookies(String requestURI) {
        try {
            if (!this.containsHeader("Set-Cookie")) {
                return null;
            }
            ClientCookie[] cookies = new ClientCookie[]{};
            Enumeration enumeration = this.getHeaders("Set-Cookie");
            while (enumeration.hasMoreElements()) {
                ClientCookie[] more = ClientCookies.parseSetCookies0((String)enumeration.nextElement(), requestURI);
                cookies = (ClientCookie[])ArrayUtil.addElements(cookies, more);
            }
            return cookies;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputStream getInputStream() throws IOException {
        String transferEncoding = this.getHeader("Transfer-Encoding");
        if (transferEncoding != null && transferEncoding.toLowerCase().startsWith("chunked")) {
            return new ChunkedInputStream(this.channel.getInputStream());
        }
        return this.channel.getInputStream();
    }

    public void close() throws IOException {
        if (this.httpMessage != null) {
            this.httpMessage.releaseChannel();
        }
    }

    public byte[] getBytes() throws IOException {
        InputStream input = this.getInputStream();
        int length = this.getContentLength();
        return Streams.readFully(input, length, IGLUELoggingConstants.HTTP_EVENT);
    }
}

