/*
 * Decompiled with CFR 0.152.
 */
package electric.http;

import electric.glue.IGLUELoggingConstants;
import electric.http.HTTPMessage;
import electric.http.InboundHTTPResponse;
import electric.http.cookies.ClientCookie;
import electric.net.channel.IChannel;
import electric.util.Context;
import electric.util.XURL;
import electric.util.encoding.StringEncodings;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.io.ISource;
import electric.util.log.Log;
import electric.util.mime.MIMEHeaders;
import java.io.IOException;
import java.io.OutputStream;

public final class OutboundHTTPRequest
implements IHTTPConstants,
IGLUELoggingConstants {
    private IChannel channel;
    private String version = "HTTP/1.1";
    private String method;
    private String uri;
    private String query;
    private ISource source;
    private boolean flushedHeader;
    private MIMEHeaders headers = new MIMEHeaders();

    public OutboundHTTPRequest() {
    }

    public OutboundHTTPRequest(IChannel channel) {
        this.channel = channel;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.method).append(' ').append(this.uri);
        if (this.query != null) {
            buffer.append('?').append(this.query);
        }
        buffer.append(' ').append(this.version).append('\n');
        buffer.append(this.headers.toString());
        return buffer.toString();
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public void setChannel(IChannel channel) {
        this.channel = channel;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getRequestURI() {
        return this.uri;
    }

    public void setRequestURI(String uri) {
        this.uri = uri;
    }

    public String getQueryString() {
        return this.query;
    }

    public void setQueryString(String query) {
        this.query = query;
    }

    public boolean isKeepAlive() {
        return HTTPUtil.isKeepAlive(this.headers.getHeader("Connection"), this.getVersion());
    }

    public void writeHeader() throws IOException {
        OutputStream stream = this.channel.getOutputStream();
        stream.write(StringEncodings.toProtocolEncoding(this.method));
        stream.write(32);
        if (this.uri != null) {
            stream.write(StringEncodings.toProtocolEncoding(this.uri));
        } else {
            stream.write(IHTTPConstants.SLASH);
        }
        if (this.query != null) {
            stream.write(63);
            stream.write(StringEncodings.toProtocolEncoding(this.query));
        }
        stream.write(32);
        stream.write(StringEncodings.toProtocolEncoding(this.version));
        stream.write(IHTTPConstants.EOL);
        this.headers.writeHeaders(stream);
        stream.write(IHTTPConstants.EOL);
    }

    public void flushHeader() throws IOException {
        if (!this.flushedHeader) {
            this.writeHeader();
            this.flushedHeader = true;
        }
    }

    public void setFlushedHeader(boolean flag) {
        this.flushedHeader = flag;
    }

    public MIMEHeaders getHeaders() {
        return this.headers;
    }

    public void setHeader(String name, String value) {
        this.headers.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public void setContentLength(int length) {
        this.headers.setContentLength(length);
    }

    public void setContentType(String type) {
        this.headers.setContentType(type);
    }

    public void addCookie(ClientCookie cookie) {
        if (cookie.getVersion() == 0) {
            this.addCookie0(cookie);
        } else {
            this.addCookie1(cookie);
        }
    }

    void addCookie0(ClientCookie cookie) {
        this.headers.addHeader("Cookie", cookie.getName() + "=" + cookie.getValue());
    }

    void addCookie1(ClientCookie cookie) {
    }

    public void setSource(ISource source) {
        this.source = source;
        this.setContentLength(source.getLength());
    }

    public ISource getSource() {
        return this.source;
    }

    public void writeSource() throws IOException {
        if (this.source != null) {
            this.source.write(this.channel.getOutputStream());
        }
    }

    public boolean canResendSource() {
        return this.source == null || this.source.canResend();
    }

    public void flush() throws IOException {
        this.flushHeader();
        this.channel.getOutputStream().flush();
    }

    public InboundHTTPResponse send(XURL endpoint, int maxTries, Context context) throws IOException, SecurityException {
        HTTPMessage message = new HTTPMessage(this, endpoint, maxTries, context);
        return message.send();
    }

    public byte[] get(String path, Context context) throws IOException, SecurityException {
        XURL xurl = new XURL(path);
        this.setMethod("GET");
        this.setVersion("HTTP/1.1");
        this.setHeader("Host", xurl.getHost() + ":" + xurl.getPort());
        this.setHeader("User-Agent", IHTTPConstants.SERVER_TYPE);
        String keepAliveHeader = HTTPUtil.isKeepAlive(context) ? "Keep-Alive" : "Close";
        this.setHeader("Connection", keepAliveHeader);
        this.setRequestURI(xurl.getFile());
        InboundHTTPResponse response = this.send(xurl, 2, context);
        if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
            Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)("inbound response from " + response.getHost() + '\n' + response));
        }
        if (response.getStatus() != 200) {
            String error = "http get error: " + path + " " + response.getMessage() + ".";
            throw new IOException(error + " response code: " + response.getStatus());
        }
        byte[] content = response.getBytes();
        response.close();
        return content;
    }
}

