/*
 * Decompiled with CFR 0.152.
 */
package electric.http.cookies;

import electric.http.cookies.ClientCookie;

public final class CookieHolder {
    private ClientCookie cookie;
    private long created;

    CookieHolder(ClientCookie cookie) {
        this.cookie = cookie;
        this.created = System.currentTimeMillis();
    }

    public ClientCookie getCookie() {
        return this.cookie;
    }

    public long getCreated() {
        return this.created;
    }

    public boolean expired() {
        if (this.cookie.getMaxAge() == -1) {
            return false;
        }
        return (System.currentTimeMillis() - this.created) / 1000L > (long)this.cookie.getMaxAge();
    }

    public boolean equivalent(ClientCookie cookie) {
        boolean nameEqual = false;
        boolean domainEqual = true;
        boolean pathEqual = true;
        if (this.cookie.getName() != null && cookie.getName() != null) {
            nameEqual = this.cookie.getName().equals(cookie.getName());
        }
        if (this.cookie.getDomain() != null && cookie.getDomain() != null) {
            domainEqual = this.cookie.getDomain().equals(cookie.getDomain());
        }
        if (this.cookie.getPath() != null && cookie.getPath() != null) {
            pathEqual = this.cookie.getPath().equals(cookie.getPath());
        }
        return nameEqual && domainEqual && pathEqual;
    }
}

