/*
 * Decompiled with CFR 0.152.
 */
package electric.jaxm;

import electric.jaxm.NameImpl;
import electric.jaxm.NodeImpl;
import electric.jaxm.NodesIterator;
import electric.jaxm.SOAPMessageImpl;
import electric.soap.ISOAPConstants;
import electric.xml.Attribute;
import electric.xml.Attributes;
import electric.xml.Element;
import electric.xml.Parent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

class SOAPElementImpl
extends NodeImpl
implements SOAPElement,
ISOAPConstants {
    public SOAPElementImpl() {
    }

    public SOAPElementImpl(SOAPMessageImpl message, Element node) {
        super(message, node);
    }

    public SOAPElementImpl(Name name) {
        this.node = name.getURI() == null ? new Element(name.getLocalName()) : new Element(name.getPrefix(), name.getLocalName(), name.getURI());
    }

    public SOAPElementImpl(String localName) {
        this.node = new Element(localName);
    }

    public SOAPElementImpl(String localName, String prefix, String uri) {
        this.node = new Element(prefix, localName, uri);
    }

    public Name getElementName() {
        return new NameImpl(this.getElement().getName(), this.getElement().getPrefix(), this.getElement().getNamespace());
    }

    public Element getElement() {
        return (Element)this.node;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        return this.addChildElement(name.getLocalName(), name.getPrefix(), name.getURI());
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        return this.addChildElement(localName, null, null);
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        return this.addChildElement(localName, prefix, null);
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        Element newElement = null;
        newElement = prefix == null ? this.getElement().addElement(localName) : this.getElement().addElement(prefix, localName);
        return new SOAPElementImpl(this.message, newElement);
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        Element newElement = ((SOAPElementImpl)element).getElement();
        this.getElement().addChild(newElement);
        return (SOAPElement)this.message.newNode(newElement);
    }

    public Iterator getChildElements() {
        return new NodesIterator(this.message, ((Parent)this.node).getChildren());
    }

    public Iterator getChildElements(Name name) {
        if (name.getURI() == null) {
            return new NodesIterator(this.message, this.getElement().getElements(name.getURI(), name.getLocalName()));
        }
        return new NodesIterator(this.message, this.getElement().getElements(name.getLocalName()));
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        this.getElement().addText(text);
        return this;
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        if (name.getPrefix() == null) {
            this.getElement().setAttribute(name.getLocalName(), value);
        } else {
            this.getElement().setAttribute(name.getPrefix(), name.getLocalName(), value);
        }
        return this;
    }

    public String getAttributeValue(Name name) {
        if (name.getURI() == null) {
            return this.getElement().getAttributeValue(name.getLocalName());
        }
        return this.getElement().getAttributeValue(name.getURI(), name.getLocalName());
    }

    public Iterator getAllAttributes() {
        ArrayList<NameImpl> list = new ArrayList<NameImpl>();
        Attributes attributes = this.getElement().getAttributeObjects();
        while (attributes.hasMoreElements()) {
            Attribute attribute = attributes.next();
            if (attribute.getNamespace() == null) {
                list.add(new NameImpl(attribute.getLocalName()));
                continue;
            }
            list.add(new NameImpl(attribute.getLocalName(), attribute.getPrefix(), attribute.getNamespace()));
        }
        return list.iterator();
    }

    public boolean removeAttribute(Name name) {
        Attribute attribute = null;
        attribute = name.getURI() == null ? this.getElement().getAttributeObject(name.getLocalName()) : this.getElement().getAttributeObject(name.getURI(), name.getLocalName());
        if (attribute == null) {
            return false;
        }
        attribute.remove();
        return true;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        this.getElement().setNamespace(prefix, uri);
        return this;
    }

    public String getNamespaceURI(String prefix) {
        return this.getElement().getNamespace(prefix);
    }

    public Iterator getNamespacePrefixes() {
        ArrayList<String> list = new ArrayList<String>();
        Attributes attributes = this.getElement().getAttributeObjects();
        while (attributes.hasMoreElements()) {
            Attribute attribute = attributes.next();
            if (!attribute.isNamespace()) continue;
            list.add(attribute.getPrefix());
        }
        return list.iterator();
    }

    public String getPrefix(String namespace) {
        if (namespace.equals("") || namespace.equals(this.getElement().getDefaultNamespace())) {
            return null;
        }
        String prefix = this.getElement().getNamespacePrefix(namespace);
        if (prefix == null) {
            Element root = this.getElement().getRoot();
            prefix = "n" + root.getAttributeObjects().size();
            root.setNamespace(prefix, namespace);
        }
        return prefix;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        return this.getElement().removeNamespace(prefix);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        String prefix = this.getPrefix("http://schemas.xmlsoap.org/soap/envelope/");
        this.getElement().setAttribute(prefix, "encodingStyle", encodingStyle);
    }

    public String getEncodingStyle() {
        return this.getElement().getAttributeValue("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
    }
}

