/*
 * Decompiled with CFR 0.152.
 */
package electric.net.event;

import electric.net.event.INetEventConstants;
import electric.net.event.NetLog;
import electric.util.XURL;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public final class NetEvent
implements INetEventConstants {
    private XURL endpoint;
    private Exception exception;
    private byte type;
    private long time;
    private int occurrences;

    public NetEvent(XURL endpoint, Exception exception) {
        this.endpoint = endpoint;
        this.exception = exception;
        this.type = this.getType();
        this.time = System.currentTimeMillis();
        this.occurrences = 1;
    }

    public String toString() {
        return "NetEvent( endpoint=" + this.endpoint + ", exception=" + this.exception + ", time=" + this.time + " )";
    }

    public XURL getEndpoint() {
        return this.endpoint;
    }

    public Exception getException() {
        return this.exception;
    }

    public long getTime() {
        return this.time;
    }

    public boolean retry() {
        return System.currentTimeMillis() - this.time > NetLog.getRetryPeriod();
    }

    public void dismiss() {
        NetLog.removeEvent(this);
    }

    public void reoccurred() {
        ++this.occurrences;
        this.time = System.currentTimeMillis();
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    private byte getType() {
        if (this.exception instanceof NoRouteToHostException) {
            return 1;
        }
        if (this.exception instanceof UnknownHostException) {
            return 1;
        }
        if (this.exception instanceof ConnectException) {
            return 2;
        }
        if (this.exception instanceof InterruptedException) {
            return 2;
        }
        return 3;
    }

    public boolean matches(XURL xurl) {
        if (this.type == 1) {
            return this.endpoint.getHostXURL().equals(xurl.getHostXURL());
        }
        if (this.type == 2) {
            return this.endpoint.getHostAndPortXURL().equals(xurl.getHostAndPortXURL());
        }
        return this.endpoint.equals(xurl);
    }

    public boolean matches(XURL xurl, Exception exception) {
        return this.exception.getClass().equals(exception.getClass()) && this.matches(xurl);
    }

    public void rethrow() throws IOException, SecurityException {
        if (this.exception instanceof IOException) {
            throw (IOException)this.exception;
        }
        if (this.exception instanceof SecurityException) {
            throw (SecurityException)this.exception;
        }
        throw new IOException("rethrowing " + this.exception);
    }
}

