/*
 * Decompiled with CFR 0.152.
 */
package electric.net.socket;

import electric.glue.IGLUELoggingConstants;
import electric.net.socket.ISocketFactory;
import electric.util.XURL;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;

public final class SocketFactories
implements IGLUELoggingConstants {
    private static final Hashtable protocolToFactoryClass = new Hashtable();
    private static final Hashtable protocolToFactory = new Hashtable();
    private static final String[] defaultFactories = new String[]{"electric.net.socket.tcp.TCPSocketFactory", "electric.net.socket.ssl.SSLSocketFactory"};

    private static void initFactories() {
        int i = 0;
        while (i < defaultFactories.length) {
            try {
                SocketFactories.addFactory(SocketFactories.createFactory(defaultFactories[i]));
            }
            catch (Throwable exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void addFactory(String className) {
        block3: {
            try {
                SocketFactories.addFactory(SocketFactories.createFactory(className));
            }
            catch (Throwable exception) {
                if (Log.isLogging(ILoggingConstants.CONFIG_EVENT)) {
                    Log.log(ILoggingConstants.CONFIG_EVENT, (Object)("unable to create factory for class " + className + " due to exception " + exception.toString()));
                }
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, exception);
            }
        }
    }

    public static synchronized void addFactory(ISocketFactory factory) {
        protocolToFactory.put(factory.getProtocol(), factory);
    }

    public static void removeFactory(String protocol) {
        protocolToFactory.remove(protocol);
    }

    public static void removeAllFactories() {
        protocolToFactory.clear();
    }

    public static synchronized ISocketFactory getFactory(String protocol) throws IOException {
        ISocketFactory factory;
        if (protocolToFactory.size() == 0) {
            SocketFactories.initFactories();
        }
        if ((factory = (ISocketFactory)protocolToFactory.get(protocol)) != null) {
            return factory;
        }
        String className = (String)protocolToFactoryClass.get(protocol);
        if (className == null) {
            return null;
        }
        try {
            factory = SocketFactories.createFactory(className);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        SocketFactories.addFactory(factory);
        return factory;
    }

    public static ISocketFactory createFactory(String className) throws Exception {
        Class factoryClass = ClassLoaders.loadClass(className);
        return (ISocketFactory)factoryClass.newInstance();
    }

    public static Socket createSocket(XURL xurl) throws IOException {
        ISocketFactory factory = SocketFactories.getFactory(xurl.getProtocol());
        InetAddress inetAddress = xurl.getHostAddress();
        if (inetAddress == null) {
            throw new UnknownHostException(xurl.toString());
        }
        return factory.createSocket(inetAddress, xurl.getPort());
    }

    public static Socket createSocket(XURL remote, XURL local) throws IOException {
        ISocketFactory factory = SocketFactories.getFactory(remote.getProtocol());
        InetAddress inetAddress = remote.getHostAddress();
        if (inetAddress == null) {
            throw new UnknownHostException(remote.toString());
        }
        if (local == null || local.getHostAddress() == null) {
            return factory.createSocket(remote.getHostAddress(), remote.getPort());
        }
        int localPort = local.getPort();
        return factory.createSocket(local.getHostAddress(), localPort == -1 ? 0 : localPort, inetAddress, remote.getPort());
    }

    public static Socket createSocket(Socket socket, XURL xurl) throws IOException {
        ISocketFactory factory = SocketFactories.getFactory(xurl.getProtocol());
        if (factory == null) {
            throw new RuntimeException("socket factory is not available for protocol - " + xurl.getProtocol());
        }
        return factory.createSocket(socket, xurl.getHost(), xurl.getPort(), true);
    }

    public static ServerSocket createServerSocket(XURL xurl, int backlog) throws IOException {
        ISocketFactory factory = SocketFactories.getFactory(xurl.getProtocol());
        if (factory == null) {
            throw new RuntimeException("socket factory is not available for protocol - " + xurl.getProtocol());
        }
        InetAddress address = null;
        if (!xurl.hasLocalHost()) {
            address = xurl.getHostAddress();
        }
        return factory.createServerSocket(xurl.getPort(), backlog, address);
    }
}

