/*
 * Decompiled with CFR 0.152.
 */
package electric.net.socket.ssl.providers.jsseri;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import electric.glue.IGLUELoggingConstants;
import electric.net.socket.ssl.ISSLProvider;
import electric.util.Context;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Random;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class JSSERIProvider
implements ISSLProvider,
IGLUELoggingConstants {
    private static final String DEFAULT_PASSWORD = "changeit";
    private static final Random regularRandom = new Random();
    private String trustStoreLocation;
    private String trustStorePassword;
    private String keyStoreLocation;
    private String keyStorePassword;
    private SSLSocketFactory sslSocketFactory;
    private SSLServerSocketFactory sslServerSocketFactory;

    public JSSERIProvider() throws Exception {
        this.initialize();
    }

    public void initialize() throws Exception {
        try {
            this.initProvider();
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.setSeed(regularRandom.nextLong());
            SSLContext context = SSLContext.getInstance((String)"SSL");
            context.init(this.getKeyManagers(), this.getTrustManagers(), secureRandom);
            this.sslSocketFactory = context.getSocketFactory();
            this.sslServerSocketFactory = context.getServerSocketFactory();
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "exception while initializing JSSE reference implementation", exception);
            }
            throw exception;
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        return this.sslServerSocketFactory;
    }

    private KeyManager[] getKeyManagers() throws Exception {
        this.initKeyStore();
        this.initKeyStorePassword();
        String keyManagerFactoryType = Context.getSystemProperty("sun.SSL.keymanager.type", "SunX509");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)keyManagerFactoryType);
        String keyStoreType = Context.getSystemProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        char[] passphrase = this.keyStorePassword.toCharArray();
        if (this.keyStoreLocation != null) {
            keyStore.load(new FileInputStream(this.keyStoreLocation), passphrase);
        }
        try {
            keyManagerFactory.init(keyStore, passphrase);
        }
        catch (KeyStoreException exception) {
            return null;
        }
        return keyManagerFactory.getKeyManagers();
    }

    private void initKeyStore() {
        this.keyStoreLocation = Context.getSystemProperty("javax.net.ssl.keyStore");
        String home = Context.getSystemProperty("java.home");
        if (!home.endsWith(File.separator)) {
            home = home + File.separator;
        }
        if (this.keyStoreLocation != null) {
            if (new File(this.keyStoreLocation).isAbsolute()) {
                return;
            }
            if (!this.keyStoreLocation.startsWith(File.separator)) {
                this.keyStoreLocation = File.separator + this.keyStoreLocation;
            }
            this.keyStoreLocation = home + this.keyStoreLocation;
        }
    }

    private void initKeyStorePassword() {
        this.keyStorePassword = Context.getSystemProperty("javax.net.ssl.keyStorePassword");
        if (this.keyStorePassword == null) {
            this.keyStorePassword = DEFAULT_PASSWORD;
        }
    }

    private TrustManager[] getTrustManagers() throws Exception {
        this.initTrustStore();
        this.initTrustStorePassword();
        String trustManagerFactoryType = Context.getSystemProperty("sun.SSL.trustmanager.type", "SunX509");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)trustManagerFactoryType);
        String trustStoreType = Context.getSystemProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
        KeyStore trustStore = KeyStore.getInstance(trustStoreType);
        char[] passphrase = this.trustStorePassword.toCharArray();
        if (this.trustStoreLocation != null) {
            trustStore.load(new FileInputStream(this.trustStoreLocation), passphrase);
        }
        trustManagerFactory.init(trustStore);
        return trustManagerFactory.getTrustManagers();
    }

    private void initTrustStore() {
        this.trustStoreLocation = Context.getSystemProperty("javax.net.ssl.trustStore");
        String home = Context.getSystemProperty("java.home");
        if (!home.endsWith(File.separator)) {
            home = home + File.separator;
        }
        if (this.trustStoreLocation == null) {
            String securityHome = home + "lib" + File.separator + "security" + File.separator;
            this.trustStoreLocation = securityHome + "jssecacerts";
            if (!new File(this.trustStoreLocation).exists()) {
                this.trustStoreLocation = securityHome + "cacerts";
            }
            if (!new File(this.trustStoreLocation).exists()) {
                this.trustStoreLocation = null;
            }
        } else {
            if (new File(this.trustStoreLocation).isAbsolute()) {
                return;
            }
            if (!this.trustStoreLocation.startsWith(File.separator)) {
                this.trustStoreLocation = File.separator + this.trustStoreLocation;
            }
            this.trustStoreLocation = home + this.trustStoreLocation;
        }
    }

    private void initTrustStorePassword() {
        this.trustStorePassword = Context.getSystemProperty("javax.net.ssl.trustStorePassword");
        if (this.trustStorePassword == null) {
            this.trustStorePassword = DEFAULT_PASSWORD;
        }
    }

    private void initProvider() {
        if (Security.getProvider("SunJSSE") == null) {
            Security.addProvider((java.security.Provider)new Provider());
        }
    }
}

