/*
 * Decompiled with CFR 0.152.
 */
package electric.registry.compound;

import electric.proxy.IReference;
import electric.registry.IRegistry;
import electric.registry.IRegistryListener;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.registry.compound.Entry;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public class CompoundRegistry
implements IRegistry {
    private static final int DEFAULT_PRIORITY = 5;
    private Entry[] entries = new Entry[0];
    private final Hashtable nameToListener = new Hashtable();

    public synchronized void addRegistry(String name, IRegistry registry) {
        this.addRegistry(name, registry, 5.0f);
    }

    public synchronized void addRegistry(String name, IRegistry registry, float priority) {
        Entry entry = new Entry(name, priority, registry);
        int i = 0;
        while (i < this.entries.length) {
            if (priority < this.entries[i].priority) {
                this.entries = (Entry[])ArrayUtil.insertElementAt(this.entries, entry, i);
                return;
            }
            ++i;
        }
        this.entries = (Entry[])ArrayUtil.addElement(this.entries, entry);
    }

    public synchronized IRegistry getRegistry(String name) {
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i].name.equals(name)) {
                return this.entries[i].registry;
            }
            ++i;
        }
        return null;
    }

    public synchronized IRegistry removeRegistry(String name) {
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i].name.equals(name)) {
                IRegistry registry = this.entries[i].registry;
                this.entries = (Entry[])ArrayUtil.removeElementAt(this.entries, i);
                return registry;
            }
            ++i;
        }
        return null;
    }

    public IRegistryListener addListener(String name, IRegistryListener listener) {
        return this.nameToListener.put(name, listener);
    }

    public IRegistryListener getListener(String name) {
        return (IRegistryListener)this.nameToListener.get(name);
    }

    public IRegistryListener removeListener(String name) {
        return (IRegistryListener)this.nameToListener.remove(name);
    }

    public IReference bind(String path, Class[] interfaces, Context context) throws RegistryException {
        int i = 0;
        while (i < this.entries.length) {
            IReference reference = this.entries[i].registry.bind(path, interfaces, context);
            if (reference != null) {
                return reference;
            }
            ++i;
        }
        return null;
    }

    public boolean publish(String path, Object object, Context context) throws RegistryException {
        path = path.replace('\\', '/');
        int i = 0;
        while (i < this.entries.length) {
            IRegistry registry = this.entries[i].registry;
            if (registry.publish(path, object, context)) {
                Enumeration listeners = this.nameToListener.elements();
                while (listeners.hasMoreElements()) {
                    ((IRegistryListener)listeners.nextElement()).published(registry, path, object, context);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean unpublish(String path) throws RegistryException {
        Object object = Registry.get(path);
        int i = 0;
        while (i < this.entries.length) {
            IRegistry registry = this.entries[i].registry;
            if (registry.unpublish(path)) {
                Enumeration listeners = this.nameToListener.elements();
                while (listeners.hasMoreElements()) {
                    ((IRegistryListener)listeners.nextElement()).unpublished(registry, path, object);
                }
                return true;
            }
            ++i;
        }
        return false;
    }
}

