/*
 * Decompiled with CFR 0.152.
 */
package electric.registry.rebind;

import electric.proxy.IReference;
import electric.proxy.rebind.RebindReference;
import electric.registry.IRegistry;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.util.http.HTTPUtil;

public final class RebindRegistry
implements IRegistry {
    private String trigger;

    public RebindRegistry(String trigger) {
        this.trigger = trigger;
    }

    public IReference bind(String path, Class[] interfaces, Context context) throws RegistryException {
        if (!path.startsWith(this.trigger) || !HTTPUtil.hasParameter(path, "failover")) {
            return null;
        }
        path = HTTPUtil.removeParameter(path, "failover");
        IReference reference = null;
        if (!HTTPUtil.hasParameter(path, "lazy")) {
            reference = Registry.getReference(path, interfaces, context);
        }
        return new RebindReference(Registry.getCompoundRegistry(), path, interfaces, context, reference);
    }

    public boolean publish(String path, Object object, Context context) throws RegistryException {
        return false;
    }

    public boolean unpublish(String path) throws RegistryException {
        return false;
    }
}

