/*
 * Decompiled with CFR 0.152.
 */
package electric.security.basic;

import electric.security.ICredentials;
import electric.security.IRealm;
import electric.security.basic.BasicPrincipal;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;

public class BasicRealm
implements IRealm {
    private String name;
    private Hashtable nameToPrincipal = new Hashtable();
    private Hashtable nameToPassword = new Hashtable();
    private Hashtable nameToRoles = new Hashtable();

    public BasicRealm(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration getPrincipals() {
        return this.nameToPrincipal.elements();
    }

    public Principal getPrincipal(String name) {
        return (Principal)this.nameToPrincipal.get(name);
    }

    public void addPrincipal(Principal principal) {
        this.nameToPrincipal.put(principal.getName(), principal);
    }

    public BasicPrincipal addPrincipal(String name, String password, String[] roles) {
        BasicPrincipal principal = this.addPrincipal(name, password);
        this.setRoles(name, roles);
        return principal;
    }

    public BasicPrincipal addPrincipal(String name, String password) {
        BasicPrincipal principal = new BasicPrincipal(name);
        this.addPrincipal(principal);
        this.setPassword(name, password);
        return principal;
    }

    public void setRoles(String name, String[] roles) {
        this.nameToRoles.put(name, roles.clone());
    }

    public String[] getRoles(String name) {
        return (String[])this.nameToRoles.get(name);
    }

    public boolean isUserInRole(String name, String[] roles) {
        String[] userRoles = this.getRoles(name);
        if (userRoles == null) {
            return false;
        }
        int i = 0;
        while (i < userRoles.length) {
            int j = 0;
            while (j < roles.length) {
                if (userRoles[i].equals(roles[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void setPassword(String name, String password) {
        this.nameToPassword.put(name, password);
    }

    public String getPassword(String name) {
        return (String)this.nameToPassword.get(name);
    }

    public boolean authenticate(ICredentials credentials) throws SecurityException {
        if (credentials != null) {
            return credentials.authenticate(this);
        }
        return false;
    }
}

