/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms;

import electric.server.IServer;
import electric.util.XURL;
import electric.util.string.Strings;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;

public class JMSContext
implements IServer {
    private XURL namespace;
    private String path;
    private QueueConnection qConn;
    private QueueSession qSession;
    private Queue requestQueue;
    private String requestQueueName;
    public String queueConnFactName;

    public JMSContext(XURL namespace, String path, QueueConnection qConn, QueueSession qSession, Queue requestQueue, String requestQueueName, String queueConnFactName) {
        this.namespace = namespace;
        this.path = path;
        this.qConn = qConn;
        this.qSession = qSession;
        this.requestQueue = requestQueue;
        this.requestQueueName = requestQueueName;
        this.queueConnFactName = queueConnFactName;
        if (!this.path.startsWith("/")) {
            this.path = "/" + this.path;
        }
    }

    public XURL getNamespace() {
        return this.namespace;
    }

    public Queue getRequestQueue() {
        return this.requestQueue;
    }

    public String getRequestQueueName() {
        return this.requestQueueName;
    }

    public QueueSession getSession() {
        return this.qSession;
    }

    public QueueConnection getConnection() {
        return this.qConn;
    }

    public String getLocalPath() {
        return this.path;
    }

    public XURL getPath() {
        return this.namespace;
    }

    public String getLocalPath(String uri) {
        return Strings.splice(this.path == null ? "/" : this.path, uri.substring(this.namespace.toString().length() + 1));
    }

    public String getRoot() {
        return this.path;
    }

    public String getType() {
        return "soap/jms";
    }
}

