/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms;

import electric.glue.IGLUELoggingConstants;
import electric.server.Servers;
import electric.server.jms.IJMSConstants;
import electric.server.jms.JMS;
import electric.server.jms.JMSContext;
import electric.server.jms.JMSRequest;
import electric.util.log.Log;
import electric.util.thread.ThreadPool;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;

public class JMSDispatcher
implements MessageListener,
IJMSConstants,
IGLUELoggingConstants {
    private static ThreadPool threadPool = ThreadPool.getShared();
    private Hashtable queueToContext = new Hashtable();
    private Hashtable waitingRequests = new Hashtable();

    public static void setThreadPool(ThreadPool threadPool) {
        JMSDispatcher.threadPool = threadPool;
    }

    public static ThreadPool getThreadPool() {
        return threadPool;
    }

    public void startDispatch(JMSContext context) throws JMSException {
        Queue requestQueue = context.getRequestQueue();
        QueueSession qSession = context.getSession();
        String selector = "(serviceURN IS NOT NULL) OR (wsdlRequest IS NOT NULL)";
        QueueReceiver receiver = JMS.createReceiver(qSession, requestQueue, selector);
        receiver.setMessageListener((MessageListener)this);
        String queueName = requestQueue.getQueueName();
        this.queueToContext.put(queueName, context);
        context.getConnection().start();
        Servers.addServer(queueName, context);
    }

    public static void stopDispatch(JMSContext context) throws JMSException {
        context.getSession().close();
        context.getConnection().stop();
        context.getConnection().close();
    }

    public void onMessage(Message message) {
        JMSRequest request;
        boolean isMultiPart;
        String destinationQName;
        String messageId;
        try {
            messageId = message.getJMSMessageID();
            Queue destinationQ = (Queue)message.getJMSDestination();
            destinationQName = destinationQ.getQueueName();
            isMultiPart = message.propertyExists("relatedMessage");
            if (isMultiPart) {
                messageId = message.getStringProperty("relatedMessage");
            }
        }
        catch (JMSException exception) {
            if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
                Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("exception while accessing message properties. message discarded." + (Object)((Object)exception)));
            }
            return;
        }
        JMSContext context = (JMSContext)this.queueToContext.get(destinationQName);
        if (context == null) {
            if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
                Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("message " + messageId + " was received on an unregistered queue. message discarded"));
            }
            return;
        }
        try {
            if (isMultiPart) {
                request = (JMSRequest)this.waitingRequests.get(messageId);
                if (request == null) {
                    request = new JMSRequest(null, context);
                    this.waitingRequests.put(messageId, request);
                }
                request.addMessage((BytesMessage)message);
            } else {
                request = new JMSRequest((BytesMessage)message, context);
            }
        }
        catch (JMSException exception) {
            if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
                Log.log(IGLUELoggingConstants.JMS_EVENT, "exception while processing jms message.", exception);
            }
            return;
        }
        if (request.readyForDispatch()) {
            threadPool.run(request);
            this.waitingRequests.remove(messageId);
        } else {
            this.waitingRequests.put(messageId, request);
        }
    }
}

