/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms;

import electric.glue.IGLUELoggingConstants;
import electric.server.jms.IJMSConstants;
import electric.server.jms.JMSContext;
import electric.server.jms.wsdl.JMSToWSDL;
import electric.soap.jms.handler.JMSToSOAP;
import electric.util.array.ArrayUtil;
import electric.util.log.Log;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSession;

public class JMSRequest
implements Runnable,
IJMSConstants,
IGLUELoggingConstants {
    private static final JMSToSOAP jmsToSoap = new JMSToSOAP();
    private static final JMSToWSDL jmsToWsdl = new JMSToWSDL();
    private BytesMessage mainMessage;
    private int totalParts;
    private BytesMessage[] parts = new BytesMessage[0];
    private JMSContext context;

    public JMSRequest(BytesMessage mainMessage, JMSContext context) throws JMSException {
        this.mainMessage = mainMessage;
        this.context = context;
        this.extractTotalParts();
    }

    public void addMessage(BytesMessage message) throws JMSException {
        if (message.propertyExists("relatedMessage")) {
            this.parts = (BytesMessage[])ArrayUtil.addElement(this.parts, message);
        } else {
            this.mainMessage = message;
            this.extractTotalParts();
        }
    }

    public boolean readyForDispatch() {
        if (this.mainMessage == null) {
            return false;
        }
        return this.parts.length == this.totalParts;
    }

    private void extractTotalParts() throws JMSException {
        if (this.mainMessage != null && this.mainMessage.propertyExists("totalMessageParts")) {
            this.totalParts = this.mainMessage.getIntProperty("totalMessageParts");
        }
    }

    public int getTotalParts() {
        return this.totalParts;
    }

    public void run() {
        if (this.isWsdlRequest()) {
            jmsToWsdl.handle(this);
        } else {
            jmsToSoap.handle(this);
        }
    }

    public BytesMessage getMainMessage() {
        return this.mainMessage;
    }

    public JMSContext getJMSContext() {
        return this.context;
    }

    public Queue getResponseQueue() {
        Queue responseQueue;
        block2: {
            responseQueue = null;
            try {
                responseQueue = (Queue)this.mainMessage.getJMSReplyTo();
            }
            catch (JMSException exception) {
                if (!Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) break block2;
                Log.log(IGLUELoggingConstants.JMS_EVENT, "response queue is not set, any response to this request will be discarded", exception);
            }
        }
        return responseQueue;
    }

    public QueueSession createResponseSession() {
        QueueSession qSession;
        block2: {
            qSession = null;
            try {
                qSession = this.context.getConnection().createQueueSession(false, 1);
            }
            catch (JMSException exception) {
                if (!Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) break block2;
                Log.log(IGLUELoggingConstants.JMS_EVENT, "response session cannot be created, any response to this request will be discarded", exception);
            }
        }
        return qSession;
    }

    private boolean isWsdlRequest() {
        try {
            return this.mainMessage.propertyExists("wsdlRequest");
        }
        catch (Exception exception) {
            block2: {
                if (!Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) break block2;
                Log.log(IGLUELoggingConstants.JMS_EVENT, "failed to get JMS message property", exception);
            }
            return false;
        }
    }
}

