/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms.j2ee;

import com.sun.enterprise.tools.admin.AdminTool;
import electric.server.jms.IJMSAdapter;
import electric.server.jms.IJMSConstants;
import electric.util.Context;
import electric.util.jms.JMSUtil;
import java.util.Hashtable;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;

public class J2EEAdapter
implements IJMSAdapter,
IJMSConstants {
    private boolean isInitialized = false;
    private Hashtable jndiProps;

    public void startup(Context context) {
        if (!this.isStarted()) {
            Hashtable userJndiProps = (Hashtable)Context.getProperty(context, "jndiProperties");
            this.jndiProps = this.getJNDILookupProps();
            if (userJndiProps != null) {
                JMSUtil.mergeProps(userJndiProps, this.jndiProps);
            }
            this.isInitialized = true;
        }
    }

    public boolean isStarted() {
        return this.isInitialized;
    }

    public Context getStartupContext() {
        if (!this.isStarted()) {
            throw new IllegalStateException("adapter is not started, unable to gather startup context information");
        }
        Context context = new Context();
        context.setProperty("jndiProperties", this.jndiProps);
        return context;
    }

    public void shutdown() {
        this.isInitialized = false;
    }

    public String getProviderName() {
        return "J2EE";
    }

    public String getClassName() {
        return "com.sun.enterprise.tools.admin.AdminTool";
    }

    protected Hashtable getJNDILookupProps() {
        if (this.jndiProps == null) {
            this.jndiProps = new Hashtable();
            this.jndiProps.put("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
            this.jndiProps.put("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        }
        return this.jndiProps;
    }

    public Queue getQueue(String queueName, boolean create) throws NamingException {
        if (create) {
            String[] args = new String[]{"-addJmsDestination", queueName, "queue"};
            AdminTool.main((String[])args);
        }
        return JMSUtil.lookupQ(queueName, this.getJNDILookupProps());
    }

    public QueueConnectionFactory getQueueConnectionFactory(String queueConnFactoryName, boolean create) throws NamingException {
        if (create) {
            String[] args = new String[]{"-addJmsFactory", queueConnFactoryName, "queue"};
            AdminTool.main((String[])args);
        }
        return JMSUtil.lookupQConnFactory(queueConnFactoryName, this.getJNDILookupProps());
    }

    private String installTopic(String topicName) {
        String[] args = new String[]{"-addJmsDestination", topicName, "topic"};
        AdminTool.main((String[])args);
        return topicName;
    }

    private String installTopicConnectionFactory(String topicConnFactoryName) {
        String[] args = new String[]{"-addJmsFactory", topicConnFactoryName, "topic"};
        AdminTool.main((String[])args);
        return topicConnFactoryName;
    }
}

