/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms.mqseries;

import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import electric.server.jms.IJMSAdapter;
import electric.server.jms.IJMSConstants;
import electric.util.Context;
import electric.util.jms.JMSUtil;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;

public class MQSeriesAdapter
implements IJMSAdapter,
IJMSConstants {
    public static final String JMS_MQDEFAULTBASEQUEUENAME = "jmsMQDefaultBaseQueueName";
    private String defaultBaseQueueName = "SYSTEM.DEFAULT.LOCAL.QUEUE";
    private Hashtable jndiProperties;
    private InitialContext initialContext;
    private Context context;
    private boolean isRunning;

    public void startup(Context context) throws NamingException {
        String defaultBaseQueueName;
        if (this.isStarted()) {
            return;
        }
        Hashtable userJndiProps = (Hashtable)Context.getProperty(context, "jndiProperties");
        this.jndiProperties = this.getJNDILookupProps();
        if (userJndiProps != null) {
            JMSUtil.mergeProps(userJndiProps, this.jndiProperties);
        }
        if ((defaultBaseQueueName = (String)Context.getProperty(context, JMS_MQDEFAULTBASEQUEUENAME)) != null) {
            this.defaultBaseQueueName = defaultBaseQueueName;
        }
        this.initialContext = new InitialContext(this.jndiProperties);
        this.context = context;
        this.isRunning = true;
        new Thread(new Runnable(){

            public void run() {
                while (MQSeriesAdapter.this.isRunning) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }

    public boolean isStarted() {
        return this.isRunning;
    }

    public void shutdown() throws NamingException {
        if (this.initialContext != null) {
            this.initialContext.close();
        }
        this.isRunning = false;
        this.context = null;
    }

    public Context getStartupContext() {
        if (!this.isStarted()) {
            throw new IllegalStateException("adapter is not started, unable to gather startup context information");
        }
        return this.context;
    }

    public Queue getQueue(String queueName, boolean create) throws JMSException, NamingException {
        if (create) {
            MQQueue queue = new MQQueue();
            Object property = this.getProperty(queueName, this.context, "DESC");
            if (property != null || (property = this.getProperty(queueName, this.context, "DESCRIPTION")) != null) {
                queue.setDescription((String)property);
            }
            if ((property = this.getProperty(queueName, this.context, "PER")) != null || (property = this.getProperty(queueName, this.context, "PERSISTENCE")) != null) {
                queue.setPersistence((int)this.resolve((String)property, "PER"));
            }
            if ((property = this.getProperty(queueName, this.context, "ENC")) != null || (property = this.getProperty(queueName, this.context, "ENCODING")) != null) {
                queue.setEncoding((int)this.resolve((String)property, "ENC"));
            }
            if ((property = this.getProperty(queueName, this.context, "TC")) != null || (property = this.getProperty(queueName, this.context, "TARGCLIENT")) != null) {
                queue.setTargetClient((int)this.resolve((String)property, "TC"));
            }
            if ((property = this.getProperty(queueName, this.context, "QU")) != null || (property = this.getProperty(queueName, this.context, "QUEUE")) != null) {
                queue.setBaseQueueName((String)property);
            }
            if ((property = this.getProperty(queueName, this.context, "QMGR")) != null || (property = this.getProperty(queueName, this.context, "QMANAGER")) != null) {
                queue.setBaseQueueManagerName((String)property);
            }
            if ((property = this.getProperty(queueName, this.context, "EXP")) != null || (property = this.getProperty(queueName, this.context, "EXPIRY")) != null) {
                queue.setExpiry(this.resolve((String)property, "EXP"));
            }
            if ((property = this.getProperty(queueName, this.context, "PRI")) != null || (property = this.getProperty(queueName, this.context, "PRIORITY")) != null) {
                queue.setPriority((int)this.resolve((String)property, "PRI"));
            }
            if ((property = this.getProperty(queueName, this.context, "CCS")) != null || (property = this.getProperty(queueName, this.context, "CCSID")) != null) {
                queue.setCCSID((int)this.resolve((String)property, "CCS"));
            }
            if (queue.getBaseQueueName() == null) {
                queue.setBaseQueueName(this.defaultBaseQueueName);
            }
            queueName = this.formatQueueName(queueName);
            this.bind(queueName, queue);
            return queue;
        }
        return JMSUtil.lookupQ(this.formatQueueName(queueName), this.getJNDILookupProps());
    }

    public QueueConnectionFactory getQueueConnectionFactory(String queueConnFactoryName, boolean create) throws JMSException, NamingException {
        if (!create) {
            return JMSUtil.lookupQConnFactory(this.formatQConnFactName(queueConnFactoryName), this.getJNDILookupProps());
        }
        MQQueueConnectionFactory connFactory = new MQQueueConnectionFactory();
        Object property = this.getProperty(queueConnFactoryName, this.context, "TRAN");
        if (property != null || (property = this.getProperty(queueConnFactoryName, this.context, "TRANSPORT")) != null) {
            connFactory.setTransportType((int)this.resolve((String)property, "TRAN"));
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "QMGR")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "QMANAGER")) != null) {
            connFactory.setQueueManager((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "PORT")) != null) {
            connFactory.setPort((int)this.resolve((String)property, "PORT"));
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "CHAN")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "CHANNEL")) != null) {
            connFactory.setChannel((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "CCS")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "CCSID")) != null) {
            connFactory.setCCSID((int)this.resolve((String)property, "CCS"));
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "TM")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "TEMPMODEL")) != null) {
            connFactory.setTemporaryModel((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "MRET")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "MSGRETENTION")) != null) {
            connFactory.setMessageRetention((int)this.resolve((String)property, "MRET"));
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "SPAG")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "SYNCPOINTALLGETS")) != null) {
            connFactory.setSyncpointAllGets(this.resolve((String)property, "MRET") == 1L);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "MBS")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "MSGBATCHSZ")) != null) {
            connFactory.setMsgBatchSize((int)this.resolve((String)property, "MRET"));
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "PINT")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "POLLINGINT")) != null) {
            connFactory.setPollingInterval((int)this.resolve((String)property, "PINT"));
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "UCP")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "USECONNPOOLING")) != null) {
            connFactory.setUseConnectionPooling(this.resolve((String)property, "UCP") == 1L);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "DESC")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "DESCRIPTION")) != null) {
            connFactory.setDescription((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "CID")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "CLIENTID")) != null) {
            connFactory.setClientId((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "HOST")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "HOSTNAME")) != null) {
            connFactory.setHostName((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "RCX")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "RECEXIT")) != null) {
            connFactory.setReceiveExit((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "RCXI")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "RECEXITINIT")) != null) {
            connFactory.setReceiveExitInit((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "SCX")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "SECEXIT")) != null) {
            connFactory.setSecurityExit((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "SCXI")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "SECEXITINIT")) != null) {
            connFactory.setSecurityExitInit((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "SDX")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "SENDEXIT")) != null) {
            connFactory.setSendExit((String)property);
        }
        if ((property = this.getProperty(queueConnFactoryName, this.context, "SDXI")) != null || (property = this.getProperty(queueConnFactoryName, this.context, "SENDEXITINIT")) != null) {
            connFactory.setSendExitInit((String)property);
        }
        queueConnFactoryName = this.formatQConnFactName(queueConnFactoryName);
        this.bind(queueConnFactoryName, connFactory);
        return connFactory;
    }

    public String getClassName() {
        return "com.ibm.mq.jms.MQQueue";
    }

    protected Hashtable getJNDILookupProps() {
        if (this.jndiProperties == null) {
            this.jndiProperties = new Hashtable();
            this.jndiProperties.put("java.naming.factory.initial", "com.sun.jndi.fscontext.RefFSContextFactory");
            this.jndiProperties.put("java.naming.provider.url", "file:/" + System.getProperty("user.home"));
        }
        return this.jndiProperties;
    }

    private String formatQueueName(String queueName) {
        return queueName.replace('/', '.');
    }

    private String formatQConnFactName(String queueConnFactName) {
        return queueConnFactName.replace('/', '.');
    }

    public String getProviderName() {
        return "MQSeries";
    }

    public String getDefaultBaseQueueName() {
        return this.defaultBaseQueueName;
    }

    public void setDefaultBaseQueueName(String defaultBaseQueueName) {
        this.defaultBaseQueueName = defaultBaseQueueName;
    }

    private void bind(String jndiName, Object object) throws NamingException {
        try {
            this.initialContext.bind(jndiName, object);
        }
        catch (NameAlreadyBoundException exception) {}
    }

    private long resolve(String propertyValue, String propertyName) {
        if (propertyName.equals("PER")) {
            if (propertyValue.equals("APP")) {
                return -2L;
            }
            if (propertyValue.equals("QDEF")) {
                return -1L;
            }
            if (propertyValue.equals("NON")) {
                return 1L;
            }
            if (propertyValue.equals("PERS")) {
                return 2L;
            }
            throw new IllegalArgumentException("invalid property value. property name PER, property value " + propertyValue);
        }
        if (propertyName.equals("ENC")) {
            if (propertyValue.equals("NATIVE")) {
                return 273L;
            }
            if (propertyValue.length() == 3) {
                int encCode = 0;
                char encChar = propertyValue.charAt(0);
                if (encChar == 'N') {
                    encCode |= 1;
                } else if (encChar == 'R') {
                    encCode |= 2;
                }
                encChar = propertyValue.charAt(1);
                if (encChar == 'N') {
                    encCode |= 0x10;
                } else if (encChar == 'R') {
                    encCode |= 0x20;
                }
                encChar = propertyValue.charAt(2);
                if (encChar == 'N') {
                    encCode |= 0x100;
                } else if (encChar == 'R') {
                    encCode |= 0x200;
                } else if (encChar == '3') {
                    encCode |= 0x300;
                }
                return encCode;
            }
            throw new IllegalArgumentException("invalid property value. property name ENC, property value " + propertyValue);
        }
        if (propertyName.equals("TC")) {
            if (propertyValue.equals("JMS")) {
                return 0L;
            }
            if (propertyValue.equals("MQ")) {
                return 1L;
            }
            throw new IllegalArgumentException("invalid property value. property name TC, property value " + propertyValue);
        }
        if (propertyName.equals("EXP")) {
            if (propertyValue.equals("APP")) {
                return -2L;
            }
            if (propertyValue.equals("UNLIM")) {
                return 0L;
            }
            try {
                return Long.parseLong(propertyValue);
            }
            catch (NumberFormatException numberformatexception) {
                throw new IllegalArgumentException("invalid property value. property name EXP, property value " + propertyValue);
            }
        }
        if (propertyName.equals("PRI")) {
            if (propertyValue.equals("APP")) {
                return -2L;
            }
            if (propertyValue.equals("QDEF")) {
                return -1L;
            }
            try {
                return Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException numberformatexception) {
                throw new IllegalArgumentException("invalid property value. property name PRI, property value " + propertyValue);
            }
        }
        if (propertyName.equals("CCS") || propertyName.equals("PORT") || propertyName.equals("MBS") || propertyName.equals("PINT")) {
            try {
                return Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException numberformatexception) {
                throw new IllegalArgumentException("invalid property value. property name CCS, property value " + propertyValue);
            }
        }
        if (propertyName.equals("TRAN")) {
            if (propertyValue.equals("BIND")) {
                return 0L;
            }
            if (propertyValue.equals("CLIENT")) {
                return 1L;
            }
            throw new IllegalArgumentException("invalid property value. property name TRAN, property value " + propertyValue);
        }
        if (propertyName.equals("MRET") || propertyName.equals("SPAG") || propertyName.equals("UCP")) {
            if (propertyValue.equals("NO")) {
                return 0L;
            }
            if (propertyValue.equals("YES")) {
                return 1L;
            }
            throw new IllegalArgumentException("invalid property value. property name MRET, property value " + propertyValue);
        }
        throw new IllegalArgumentException("unknown property name " + propertyName);
    }

    private Object getProperty(String prefix, Context context, String propertyName) {
        return Context.getProperty(context, prefix + ":" + propertyName);
    }
}

