/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms.swiftmq;

import com.swiftmq.admin.cli.CLI;
import com.swiftmq.admin.cli.CLIException;
import electric.server.jms.IJMSAdapter;
import electric.server.jms.IJMSConstants;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.jms.JMSUtil;
import electric.util.string.Strings;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SwiftMQAdapter
implements IJMSAdapter,
IJMSConstants {
    private Hashtable jndiProps;
    private QueueConnection connection;
    private String routerName;
    private CLI cli;

    public SwiftMQAdapter() {
        try {
            this.routerName = Context.getSystemProperty("swiftmq.routername", "router1");
        }
        catch (Exception exception) {
            this.routerName = "router1";
        }
    }

    public void startup(Context context) throws JMSException, NamingException {
        if (this.isStarted()) {
            return;
        }
        Hashtable userJndiProps = (Hashtable)Context.getProperty(context, "jndiProperties");
        this.jndiProps = this.getJNDILookupProps();
        if (userJndiProps != null) {
            JMSUtil.mergeProps(userJndiProps, this.jndiProps);
        }
        this.cli = this.createCLI();
    }

    public boolean isStarted() {
        return this.cli != null;
    }

    public void shutdown() throws JMSException {
        if (this.cli != null) {
            this.cli.close();
            this.cli = null;
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public Context getStartupContext() {
        if (!this.isStarted()) {
            throw new IllegalStateException("adapter is not started, unable to gather startup context information");
        }
        Context context = new Context();
        context.setProperty("jndiProperties", this.jndiProps);
        return context;
    }

    public String getProviderName() {
        return "SwiftMQ";
    }

    public String getClassName() {
        return "com.swiftmq.admin.cli.CLI";
    }

    protected Hashtable getJNDILookupProps() {
        if (this.jndiProps == null) {
            this.jndiProps = new Hashtable();
            this.jndiProps.put("java.naming.factory.initial", "com.swiftmq.jndi.InitialContextFactoryImpl");
            this.jndiProps.put("java.naming.provider.url", "smqp://localhost:4001/;timeout=10000");
        }
        return this.jndiProps;
    }

    public Queue getQueue(String queueName, boolean create) throws JMSException, NamingException {
        queueName = this.formatQueueName(queueName);
        if (create) {
            try {
                this.cli.waitForRouter(this.routerName);
                this.cli.executeCommand("sr " + this.routerName);
                this.cli.executeCommand("cc /sys$queuemanager/queues");
                Object[] queues = this.cli.getContextEntities();
                String shortQName = Strings.head(queueName, '@');
                if (!ArrayUtil.contains(shortQName, queues)) {
                    this.cli.executeCommand("new " + shortQName);
                    this.cli.executeCommand("save");
                    this.cli.executeCommand("cc ..");
                    this.cli.executeCommand("cc ..");
                }
            }
            catch (Exception exception) {
                throw new JMSException(exception.toString());
            }
        }
        return JMSUtil.lookupQ(queueName, this.getJNDILookupProps());
    }

    private String formatQueueName(String queueName) {
        if (queueName.endsWith("@" + this.routerName)) {
            return queueName;
        }
        return Strings.replace(queueName, "/", "") + "@" + this.routerName;
    }

    public QueueConnectionFactory getQueueConnectionFactory(String queueConnFactoryName, boolean create) throws JMSException, NamingException {
        queueConnFactoryName = this.formatQConnFactName(queueConnFactoryName);
        if (create) {
            try {
                this.cli.waitForRouter(this.routerName);
                this.cli.executeCommand("sr " + this.routerName);
                this.cli.executeCommand("cc /sys$jndi/aliases");
                Object[] aliases = this.cli.getContextEntities();
                if (!ArrayUtil.contains(queueConnFactoryName, aliases)) {
                    try {
                        this.cli.executeCommand("new " + queueConnFactoryName + " map-to plainsocket@" + this.routerName);
                        this.cli.executeCommand("save");
                        this.cli.executeCommand("cc ..");
                        this.cli.executeCommand("cc ..");
                    }
                    catch (CLIException exception) {
                        this.cli.executeCommand("new " + queueConnFactoryName + " mapto plainsocket@" + this.routerName);
                        this.cli.executeCommand("save");
                        this.cli.executeCommand("cc ..");
                        this.cli.executeCommand("cc ..");
                    }
                }
            }
            catch (Exception exception) {
                throw new JMSException(exception.toString());
            }
        }
        return JMSUtil.lookupQConnFactory(queueConnFactoryName, this.getJNDILookupProps());
    }

    private String formatQConnFactName(String queueConnFactName) {
        return Strings.replace(queueConnFactName, "/", "");
    }

    private CLI createCLI() throws JMSException, NamingException {
        InitialContext ctx = new InitialContext(this.getJNDILookupProps());
        QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("QueueConnectionFactory");
        this.connection = factory.createQueueConnection();
        ctx.close();
        try {
            return new CLI(this.connection);
        }
        catch (Exception exception) {
            throw new JMSException("unable to create CLI object", exception.toString());
        }
    }
}

