/*
 * Decompiled with CFR 0.152.
 */
package electric.service.descriptor;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.soap.wsdl.SOAPBinding;
import electric.util.reflect.MethodLookup;
import electric.xml.Element;
import java.lang.reflect.Method;

public final class MethodDescriptor
implements IGLUELoggingConstants,
IGLUEContextConstants {
    private String signature;
    private String messageName;
    private String returnName;
    private String[] argNames;
    private transient Method method;

    public MethodDescriptor(String signature) {
        this(signature, MethodDescriptor.getDefaultReturnName(signature));
    }

    public MethodDescriptor(String signature, String returnName) {
        this.signature = signature;
        this.returnName = returnName;
    }

    public MethodDescriptor(String signature, String returnName, String[] argNames) {
        this.signature = signature;
        this.returnName = returnName;
        this.argNames = argNames;
    }

    public MethodDescriptor(Method method) {
        this.method = method;
        this.signature = this.getSignature(method);
        this.returnName = MethodDescriptor.getDefaultReturnName(this.signature);
    }

    public MethodDescriptor(Element method) {
        this.signature = method.getString("signature");
        this.returnName = method.hasElement("returnName") ? method.getString("returnName") : MethodDescriptor.getDefaultReturnName(this.signature);
        if (method.hasElement("messageName")) {
            this.messageName = method.getString("messageName");
        }
    }

    public void initialize(Class javaClass) {
        try {
            Method[] array = MethodLookup.getMethodsWithSignature(javaClass, this.getSignature());
            this.method = array[0];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.messageName == null ? this.method.getName() : this.messageName;
    }

    public String getSignature() {
        return this.signature;
    }

    private String getSignature(Method method) {
        StringBuffer signature = new StringBuffer(method.getName());
        signature.append('(');
        Class<?>[] args = method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                signature.append(", ");
            }
            signature.append(args[i].getName());
            ++i;
        }
        signature.append(')');
        return signature.toString();
    }

    public String getReturnName() {
        return this.returnName;
    }

    public static String getDefaultReturnName(String signature) {
        int index = signature.indexOf(40);
        return SOAPBinding.getSOAPResultName(signature.substring(0, index));
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public void setArgNames(String[] argNames) {
        this.argNames = argNames;
    }

    public void writeMethod(Element root) {
        Element method = root.addElement("method");
        method.setString("signature", this.getSignature());
        method.setString("returnName", this.getReturnName());
        if (this.messageName != null) {
            method.setString("returnName", this.messageName);
        }
    }
}

