/*
 * Decompiled with CFR 0.152.
 */
package electric.service.descriptor.initializer;

import electric.glue.IGLUEContextConstants;
import electric.service.descriptor.IInitializer;
import electric.service.descriptor.ServiceDescriptor;
import electric.util.Context;
import electric.util.classloader.ClassLoaders;
import electric.util.reflect.Creator;

public final class Default
implements IInitializer,
IGLUEContextConstants {
    public void create(ServiceDescriptor descriptor, ClassLoader loader) throws Throwable {
        Context context = descriptor.getContext();
        this.setProperty("activation", descriptor.activation, context);
        this.setProperty("dataDirectory", descriptor.dataDirectory, context);
        this.setProperty("description", descriptor.description, context);
        this.setProperty("endpoint", descriptor.endpoint, context);
        this.setProperty("namespace", descriptor.namespace, context);
        this.setProperty("targetNamespace", descriptor.targetNamespace, context);
        this.setProperty("soapAction", descriptor.soapAction, context);
        this.setProperty("priority", Float.toString(descriptor.priority), context);
        this.setProperty("style", descriptor.style, context);
        if (descriptor.soapPersonalityClassName != null) {
            Object soapPersonality = ClassLoaders.loadClass(descriptor.soapPersonalityClassName, loader).newInstance();
            this.setProperty("soapPersonality", soapPersonality, context);
        }
        if (descriptor.wsdlPersonalityClassName != null) {
            Object wsdlPersonality = ClassLoaders.loadClass(descriptor.wsdlPersonalityClassName, loader).newInstance();
            this.setProperty("wsdlPersonality", wsdlPersonality, context);
        }
        this.setProperty("use", descriptor.use, context);
        int i = 0;
        while (i < descriptor.intf.length) {
            this.addProperty("interface", descriptor.intf[i], context);
            ++i;
        }
        int i2 = 0;
        while (i2 < descriptor.methods.length) {
            descriptor.methods[i2].initialize(descriptor.getObject().getClass());
            this.addProperty("method", descriptor.methods[i2], context);
            ++i2;
        }
        int i3 = 0;
        while (i3 < descriptor.xmlInclude.length) {
            this.addProperty("xmlInclude", descriptor.xmlInclude[i3], context);
            ++i3;
        }
        int i4 = 0;
        while (i4 < descriptor.outboundSoapResponseInterceptor.length) {
            this.addProperty("outboundSoapResponseInterceptor", descriptor.outboundSoapResponseInterceptor[i4], context);
            ++i4;
        }
        int i5 = 0;
        while (i5 < descriptor.inboundSoapRequestInterceptor.length) {
            this.addProperty("inboundSoapRequestInterceptor", descriptor.inboundSoapRequestInterceptor[i5], context);
            ++i5;
        }
        this.installDataHandler(descriptor, loader);
    }

    private void installDataHandler(ServiceDescriptor descriptor, ClassLoader loader) throws Throwable {
        Context ctx = descriptor.getContext();
        int i = 0;
        while (i < descriptor.dataHandler.length) {
            if (descriptor.dataHandler[i].hasElement("type") && descriptor.dataHandler[i].hasElement("class")) {
                String type = descriptor.dataHandler[i].getElement("type").getString();
                String className = descriptor.dataHandler[i].getElement("class").getString();
                Object object = Creator.newInstance(className, loader);
                ctx.addProperty(type + " dataHandler", object);
            }
            ++i;
        }
    }

    private void setProperty(String name, Object value, Context context) {
        if (value != null) {
            context.setProperty(name, value);
        }
    }

    private void setProperty(String name, String value, Context context) {
        if (value != null && value != "") {
            context.setProperty(name, value);
        }
    }

    private void addProperty(String name, Object value, Context context) {
        if (value != null && value != "") {
            context.addProperty(name, value);
        }
    }
}

