/*
 * Decompiled with CFR 0.152.
 */
package electric.service.ejb;

import electric.glue.IGLUELoggingConstants;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.service.IService;
import electric.service.descriptor.MethodDescriptor;
import electric.service.reference.ReferenceFactories;
import electric.util.Context;
import electric.util.Value;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.IHasClassLoader;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.Invocation;
import electric.util.reflect.Reflect;
import electric.wsdl.WSDL;
import electric.wsdl.generator.WSDLGenerator;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.ejb.EJBMetaData;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class StatelessSessionBeanService
implements IService,
IReference,
IHasClassLoader,
IGLUELoggingConstants {
    private static boolean enabled = false;
    private static boolean allowEnable = true;
    private static Class[] EXCLUDEDCLASSES;
    private static final String[] EXCLUDED;
    private String contextFactory;
    private String url;
    private String jndiName;
    private String homeClassName;
    private Context context = new Context();
    private boolean initialized = false;
    private String description;
    private WSDL wsdl;
    private Object home;
    private Method createMethod;
    private Method removeMethod;
    private Class remoteInterfaceClass;
    private IReference referenceChain;

    public StatelessSessionBeanService(String contextFactory, String url, String jndiName) throws Exception {
        this(contextFactory, url, jndiName, null);
    }

    public StatelessSessionBeanService(String contextFactory, String url, String jndiName, String homeClassName) throws Exception {
        if (!StatelessSessionBeanService.isEnabled()) {
            throw new IllegalStateException("GLUE/EJB integration is disabled");
        }
        this.contextFactory = contextFactory;
        this.url = url;
        this.jndiName = jndiName;
        this.homeClassName = homeClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws Exception {
        Properties properties = new Properties();
        if (this.contextFactory != null) {
            properties.put("java.naming.factory.initial", this.contextFactory);
        }
        if (this.url != null) {
            properties.put("java.naming.provider.url", this.url);
        }
        InitialContext initialContext = null;
        initialContext = new InitialContext(properties);
        try {
            Class<?> homeClass;
            this.home = initialContext.lookup(this.jndiName);
            if (this.homeClassName != null) {
                homeClass = ClassLoaders.loadClass(this.homeClassName);
                this.home = PortableRemoteObject.narrow((Object)this.home, homeClass);
            }
            homeClass = this.home.getClass();
            try {
                this.createMethod = homeClass.getMethod("create", null);
            }
            catch (NoSuchMethodException exception) {
                throw new RuntimeException("unable to locate EJB 'create' method on home interface. " + (this.homeClassName == null ? "make sure to set EJB home interface" : ""));
            }
            Method getMetaDataMethod = homeClass.getMethod("getEJBMetaData", null);
            EJBMetaData metaData = (EJBMetaData)getMetaDataMethod.invoke(this.home, null);
            this.remoteInterfaceClass = metaData.getRemoteInterfaceClass();
            if (this.remoteInterfaceClass == null) {
                Object bean = this.createMethod.invoke(this.home, null);
                this.remoteInterfaceClass = bean.getClass();
                this.removeMethod = this.remoteInterfaceClass.getMethod("remove", null);
                this.removeMethod.invoke(bean, null);
            }
            this.removeMethod = this.remoteInterfaceClass.getMethod("remove", null);
            if (!this.isStatelessSessionBean(metaData)) {
                throw new IllegalArgumentException(this.remoteInterfaceClass.getName() + " is not a stateless session bean");
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            initialContext.close();
            throw throwable;
        }
        initialContext.close();
    }

    private boolean isStatelessSessionBean(EJBMetaData metaData) throws Exception {
        try {
            Method isStatelessSessionBeanMethod = metaData.getClass().getMethod("isStatelessSession", new Class[0]);
            return (Boolean)isStatelessSessionBeanMethod.invoke((Object)metaData, new Object[0]);
        }
        catch (NoSuchMethodException exception) {
            return true;
        }
        catch (IllegalAccessException exception) {
            return true;
        }
    }

    private synchronized void checkInitialized() throws Exception {
        if (!StatelessSessionBeanService.isEnabled()) {
            throw new IllegalStateException("GLUE/EJB integration is disabled");
        }
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public synchronized String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        this.description = this.context.getStringProperty("description");
        if (this.description == null) {
            this.description = "UNDEFINED";
        }
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
        this.context.setProperty("description", description);
    }

    public String getNamespace() {
        return this.context.getStringProperty("namespace");
    }

    public void setNamespace(String namespace) {
        this.context.setProperty("namespace", namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value invoke(Method method, Object[] args, Context context) throws Throwable {
        Value value;
        this.checkInitialized();
        Object bean = this.createMethod.invoke(this.home, null);
        try {
            value = Invocation.invoke(bean, method, args);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.removeMethod.invoke(bean, null);
            throw throwable;
        }
        this.removeMethod.invoke(bean, null);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value invoke(String method, Object[] args, Class[] argTypes, Context context) throws Throwable {
        Value value;
        this.checkInitialized();
        Object bean = this.createMethod.invoke(this.home, null);
        try {
            value = Invocation.invoke(bean, method, args, argTypes);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.removeMethod.invoke(bean, null);
            throw throwable;
        }
        this.removeMethod.invoke(bean, null);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value invoke(String method, String[] args, Context context) throws Throwable {
        Value value;
        this.checkInitialized();
        Object bean = this.createMethod.invoke(this.home, null);
        try {
            value = Invocation.invoke(bean, method, args);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.removeMethod.invoke(bean, null);
            throw throwable;
        }
        this.removeMethod.invoke(bean, null);
        return value;
    }

    public IReference getReference() {
        if (this.referenceChain == null) {
            this.referenceChain = ReferenceFactories.getReferenceChain(this, this);
        }
        return this.referenceChain;
    }

    public ClassLoader getClassLoader() {
        return this.remoteInterfaceClass.getClassLoader();
    }

    public WSDL getWSDL() {
        block5: {
            if (this.wsdl != null) {
                return this.wsdl;
            }
            try {
                this.checkInitialized();
                XURL[] endpoints = this.getEndpoints();
                Method[] methods = this.getRemoteInterfaceMethods();
                MethodDescriptor[] descriptors = new MethodDescriptor[methods.length];
                Class descriptorClass = this.getInterface();
                if (descriptorClass == null) {
                    descriptorClass = this.remoteInterfaceClass;
                }
                int j = 0;
                while (j < methods.length) {
                    descriptors[j] = new MethodDescriptor(methods[j]);
                    ++j;
                }
                this.wsdl = WSDLGenerator.getWSDL(endpoints, this.getDescription(), this.context, descriptors, descriptorClass);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block5;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to create WSDL for EJB service", exception);
            }
        }
        return this.wsdl;
    }

    private synchronized Class[] getExcludedClasses() {
        if (EXCLUDEDCLASSES != null) {
            return EXCLUDEDCLASSES;
        }
        EXCLUDEDCLASSES = new Class[0];
        int i = 0;
        while (i < EXCLUDED.length) {
            try {
                Class classObj = ClassLoaders.loadClass(EXCLUDED[i]);
                EXCLUDEDCLASSES = (Class[])ArrayUtil.addElement(EXCLUDEDCLASSES, classObj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return EXCLUDEDCLASSES;
    }

    private Method[] getRemoteInterfaceMethods() {
        Method[] methods = null;
        if (this.remoteInterfaceClass.isInterface()) {
            methods = Reflect.getInterfaceMethods(this.remoteInterfaceClass);
        } else {
            Class[] interfaces = Reflect.getInterfaces(this.remoteInterfaceClass);
            methods = new Method[]{};
            int i = 0;
            while (i < interfaces.length) {
                methods = (Method[])ArrayUtil.addElements(methods, Reflect.getInterfaceMethods(interfaces[i]));
                ++i;
            }
        }
        return Reflect.getMethodsNotImplementedBy(methods, this.getExcludedClasses());
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("EJB integration cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"JMS integration feature disabled");
    }

    public static void create(String name, String contextFactory, String url, String jndiName, String homeClassName) throws Exception {
        StatelessSessionBeanService bean = new StatelessSessionBeanService(contextFactory, url, jndiName, homeClassName);
        Registry.publish(name, bean);
    }

    public static void create(String name, String contextFactory, String url, String jndiName, String homeClassName, Context ctx) throws Exception {
        StatelessSessionBeanService bean = new StatelessSessionBeanService(contextFactory, url, jndiName, homeClassName);
        Registry.publish(name, (Object)bean, ctx);
    }

    protected XURL[] getEndpoints() throws MalformedURLException {
        XURL[] endpoints = null;
        Enumeration enumeration = this.context.getProperties("endpoint");
        if (enumeration.hasMoreElements()) {
            endpoints = new XURL[]{};
            while (enumeration.hasMoreElements()) {
                XURL endpoint = new XURL((String)enumeration.nextElement());
                endpoints = (XURL[])ArrayUtil.addElement(endpoints, endpoint);
            }
        } else {
            String[] urls = Registry.getAllPaths(this);
            if (urls.length == 0) {
                urls = new String[]{Registry.getPath("/", (Object)this)};
            }
            endpoints = new XURL[urls.length];
            int i = 0;
            while (i < endpoints.length) {
                endpoints[i] = new XURL(urls[i]);
                ++i;
            }
        }
        return endpoints;
    }

    protected synchronized Class getInterface() throws ClassNotFoundException {
        String name = (String)this.context.getProperty("interface");
        return name == null ? null : ClassLoaders.loadClass(name, this.getClassLoader());
    }

    static {
        EXCLUDED = new String[]{"java.lang.Object", "javax.ejb.EJBObject", "javax.rmi.CORBA.Stub", "org.omg.CORBA_2_3.portable.ObjectImpl"};
    }
}

