/*
 * Decompiled with CFR 0.152.
 */
package electric.service.ejb.server;

import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.service.ejb.StatelessSessionBeanService;
import electric.service.ejb.client.JNDILookupInfo;
import electric.service.ejb.server.IJNDIBroker;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBMetaData;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JNDIBroker
implements IJNDIBroker,
ILoggingConstants {
    private String contextFactory;
    private String providerURL;
    private String registryPath;
    private Hashtable jndiLookups = new Hashtable();
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBHome;

    public JNDIBroker(String contextFactory, String providerURL, String registryPath) {
        this.contextFactory = contextFactory;
        this.providerURL = providerURL;
        this.registryPath = registryPath;
    }

    public JNDILookupInfo lookupObject(String jndiName) {
        block4: {
            try {
                String publishName = jndiName.replace('/', '-');
                publishName = publishName.replace('.', '-');
                publishName = Strings.splice(this.registryPath, publishName);
                if (this.jndiLookups.containsKey(publishName)) {
                    return (JNDILookupInfo)this.jndiLookups.get(publishName);
                }
                StatelessSessionBeanService serviceObj = new StatelessSessionBeanService(this.contextFactory, this.providerURL, jndiName);
                Registry.publish(publishName, serviceObj);
                String wsdlURL = Registry.getPath(serviceObj) + ".wsdl";
                String[] interfaces = this.getRemoteInterfaceName(jndiName);
                JNDILookupInfo lookupInfo = new JNDILookupInfo(wsdlURL, interfaces[0], interfaces[1]);
                this.jndiLookups.put(publishName, lookupInfo);
                return lookupInfo;
            }
            catch (RegistryException exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block4;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to publish EJB web service wrapper. jndi name " + jndiName, exception);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block4;
                Log.log(ILoggingConstants.ERROR_EVENT, "error creating EJB web service wrapper. jndi name " + jndiName, exception);
            }
        }
        return null;
    }

    private String[] getRemoteInterfaceName(String jndiName) throws NamingException {
        Properties properties = new Properties();
        if (this.contextFactory != null) {
            properties.put("java.naming.factory.initial", this.contextFactory);
        }
        if (this.providerURL != null) {
            properties.put("java.naming.provider.url", this.providerURL);
        }
        InitialContext initialContext = null;
        initialContext = properties.size() > 0 ? new InitialContext(properties) : new InitialContext();
        Class remoteInterfaceClass = null;
        Class homeInterfaceClass = null;
        try {
            Object home = initialContext.lookup(jndiName);
            Class<?> homeClass = home.getClass();
            Method getMetaDataMethod = homeClass.getMethod("getEJBMetaData", null);
            try {
                EJBMetaData metaData = (EJBMetaData)getMetaDataMethod.invoke(home, null);
                remoteInterfaceClass = metaData.getRemoteInterfaceClass();
                homeInterfaceClass = metaData.getHomeInterfaceClass();
            }
            catch (InvocationTargetException exception) {
                exception.getTargetException().printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (remoteInterfaceClass == null) {
                Method createMethod = homeClass.getMethod("create", null);
                Object bean = createMethod.invoke(home, null);
                remoteInterfaceClass = this.getInterface(bean, class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = JNDIBroker.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject);
                Method removeMethod = remoteInterfaceClass.getMethod("remove", null);
                removeMethod.invoke(bean, null);
            }
            if (homeInterfaceClass == null) {
                homeInterfaceClass = this.getInterface(home, class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = JNDIBroker.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome);
            }
            String interfaceName = remoteInterfaceClass == null ? null : remoteInterfaceClass.getName();
            return new String[]{homeInterfaceClass.getName(), interfaceName};
        }
        catch (Throwable throwable) {
            block9: {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block9;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to resolve remote interface name due to exception", throwable);
            }
            return null;
        }
    }

    private Class getInterface(Object object, Class markerClass) {
        Class<?>[] interfaces = object.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (markerClass.isAssignableFrom(interfaces[i]) && !markerClass.getName().equals(interfaces[i].getName())) {
                return interfaces[i];
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

