/*
 * Decompiled with CFR 0.152.
 */
package electric.service.instrumentation;

import electric.proxy.chain.ChainedReference;
import electric.service.IService;
import electric.service.instrumentation.listener.IInstrumentationListener;
import electric.util.Context;
import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.wsdl.WSDL;
import java.lang.reflect.Method;

public class InstrumentingReference
extends ChainedReference {
    private IService service;
    private IInstrumentationListener[] listeners = new IInstrumentationListener[0];

    InstrumentingReference(IService service) {
        this.service = service;
    }

    public WSDL getWSDL() {
        return this.nextReference.getWSDL();
    }

    public Value invoke(Method method, Object[] args, Context context) throws Throwable {
        this.instrumentPreInvoke(method.getName(), this.getArgsLength(args));
        try {
            Value value = this.nextReference.invoke(method, args, context);
            this.instrumentPostInvokeSuccess(method.getName(), this.getArgsLength(args));
            return value;
        }
        catch (Throwable throwable) {
            this.instrumentPostInvokeFailure(method.getName(), this.getArgsLength(args));
            throw throwable;
        }
    }

    public Value invoke(String method, Object[] args, Class[] argTypes, Context context) throws Throwable {
        this.instrumentPreInvoke(method, this.getArgsLength(args));
        try {
            Value value = this.nextReference.invoke(method, args, argTypes, context);
            this.instrumentPostInvokeSuccess(method, this.getArgsLength(args));
            return value;
        }
        catch (Throwable throwable) {
            this.instrumentPostInvokeFailure(method, this.getArgsLength(args));
            throw throwable;
        }
    }

    public Value invoke(String method, String[] args, Context context) throws Throwable {
        this.instrumentPreInvoke(method, this.getArgsLength(args));
        try {
            Value value = this.nextReference.invoke(method, args, context);
            this.instrumentPostInvokeSuccess(method, this.getArgsLength(args));
            return value;
        }
        catch (Throwable throwable) {
            this.instrumentPostInvokeFailure(method, this.getArgsLength(args));
            throw throwable;
        }
    }

    private int getArgsLength(Object[] args) {
        return args == null ? 0 : args.length;
    }

    private void instrumentPreInvoke(String method, int args) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].preInvoke(this.service, method, args);
            ++i;
        }
    }

    private void instrumentPostInvokeSuccess(String method, int args) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].postInvokeSuccess(this.service, method, args);
            ++i;
        }
    }

    private void instrumentPostInvokeFailure(String method, int args) {
        int i = 0;
        while (i < this.listeners.length) {
            this.listeners[i].postInvokeFailure(this.service, method, args);
            ++i;
        }
    }

    public void addListener(IInstrumentationListener listener) {
        listener.prepareService(this.service);
        this.listeners = (IInstrumentationListener[])ArrayUtil.addElement(this.listeners, listener);
    }
}

