/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet;

import electric.glue.IGLUELoggingConstants;
import electric.servlet.HTTPContext;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

class HTTPContextListeners
implements IGLUELoggingConstants {
    private HTTPContext context;
    private ServletContextListener[] contextListeners = new ServletContextListener[0];
    private ServletContextAttributeListener[] attributeListeners = new ServletContextAttributeListener[0];

    public HTTPContextListeners(HTTPContext parentContext) {
        this.context = parentContext;
    }

    public void notifyStartup() {
        if (this.contextListeners.length == 0) {
            return;
        }
        ServletContextEvent contextEvent = new ServletContextEvent((ServletContext)this.context);
        int i = 0;
        while (i < this.contextListeners.length) {
            this.contextListeners[i].contextInitialized(contextEvent);
            ++i;
        }
    }

    public void notifyShutdown() {
        if (this.contextListeners.length == 0) {
            return;
        }
        ServletContextEvent contextEvent = new ServletContextEvent((ServletContext)this.context);
        int i = this.contextListeners.length - 1;
        while (i >= 0) {
            this.contextListeners[i].contextDestroyed(contextEvent);
            --i;
        }
    }

    public void notifyAttributeAdded(String name, Object value) {
        if (this.attributeListeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent contextEvent = new ServletContextAttributeEvent((ServletContext)this.context, name, value);
        int i = 0;
        while (i < this.attributeListeners.length) {
            this.attributeListeners[i].attributeAdded(contextEvent);
            ++i;
        }
    }

    public void notifyAttributeReplaced(String name, Object prevValue) {
        if (this.attributeListeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent contextEvent = new ServletContextAttributeEvent((ServletContext)this.context, name, prevValue);
        int i = 0;
        while (i < this.attributeListeners.length) {
            this.attributeListeners[i].attributeReplaced(contextEvent);
            ++i;
        }
    }

    public void notifyAttributeRemoved(String name, Object prevValue) {
        if (this.attributeListeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent contextEvent = new ServletContextAttributeEvent((ServletContext)this.context, name, prevValue);
        int i = 0;
        while (i < this.attributeListeners.length) {
            this.attributeListeners[i].attributeRemoved(contextEvent);
            ++i;
        }
    }

    public void addListener(String listenerClassName) {
        if (listenerClassName == null) {
            if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)"problem adding servlet context listeners: no listener name");
            }
            return;
        }
        ClassLoader loader = this.context.getClassLoader();
        if (loader == null) {
            if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)"problem adding servlet context listeners: no loader");
            }
            return;
        }
        Object listenerObj = null;
        try {
            Class<?> listenerClass = loader.loadClass(listenerClassName);
            listenerObj = listenerClass.newInstance();
        }
        catch (Throwable throwable) {
            if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)("problem with servlet context listener name :" + listenerClassName + ":" + throwable));
            }
            return;
        }
        if (listenerObj instanceof ServletContextListener) {
            this.contextListeners = (ServletContextListener[])ArrayUtil.addElement(this.contextListeners, listenerObj);
        } else if (listenerObj instanceof ServletContextAttributeListener) {
            this.attributeListeners = (ServletContextAttributeListener[])ArrayUtil.addElement(this.attributeListeners, listenerObj);
        } else if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)("bad type for servlet context listener :" + listenerClassName));
        }
    }
}

