/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet;

import java.util.Hashtable;

public final class HTTPError {
    private static final Hashtable exceptions = new Hashtable();

    private static void addException(int code, String message) {
        exceptions.put(new Integer(code), message);
    }

    public static String getStatusMessage(int code) {
        return (String)exceptions.get(new Integer(code));
    }

    private static void initExceptions() {
        HTTPError.addException(202, "Accepted");
        HTTPError.addException(502, "Bad Gateway");
        HTTPError.addException(400, "Bad Request");
        HTTPError.addException(409, "Conflict");
        HTTPError.addException(100, "Continue");
        HTTPError.addException(201, "Created");
        HTTPError.addException(403, "Forbidden");
        HTTPError.addException(504, "Gateway Time-out");
        HTTPError.addException(410, "Gone");
        HTTPError.addException(505, "HTTP Version not supported");
        HTTPError.addException(500, "Internal Server Error");
        HTTPError.addException(411, "Length Required");
        HTTPError.addException(405, "Method Not Allowed");
        HTTPError.addException(301, "Moved Permanently");
        HTTPError.addException(302, "Found");
        HTTPError.addException(300, "Multiple Choices");
        HTTPError.addException(204, "No Content");
        HTTPError.addException(203, "Non-Authoritative Information");
        HTTPError.addException(406, "Not Acceptable");
        HTTPError.addException(404, "Not Found");
        HTTPError.addException(501, "Not Implemented");
        HTTPError.addException(304, "Not Modified");
        HTTPError.addException(200, "OK");
        HTTPError.addException(206, "Partial Content");
        HTTPError.addException(402, "Payment Required");
        HTTPError.addException(412, "Precondition Failed");
        HTTPError.addException(407, "Proxy Authentication Required");
        HTTPError.addException(413, "Request Entity Too Large");
        HTTPError.addException(408, "Request Time-out");
        HTTPError.addException(414, "Request-URI Too Large");
        HTTPError.addException(205, "Reset Content");
        HTTPError.addException(303, "See Other");
        HTTPError.addException(503, "Service Unavailable");
        HTTPError.addException(101, "Switching Protocols");
        HTTPError.addException(401, "Unauthorized");
        HTTPError.addException(415, "Unsupported Media Type");
        HTTPError.addException(305, "Use Proxy");
    }

    static {
        HTTPError.initExceptions();
    }
}

