/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet;

import electric.net.channel.IChannel;
import electric.servlet.Config;
import electric.servlet.HTTPContext;
import electric.servlet.OutboundHTTPResponse;
import electric.servlet.cookies.Cookies;
import electric.servlet.locales.RequestLocales;
import electric.servlet.sessions.HTTPSession;
import electric.servlet.streams.ServletInput;
import electric.util.XURL;
import electric.util.encoding.StringEncodings;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.io.ChunkedInputStream;
import electric.util.io.Streams;
import electric.util.mime.MIMEHeaders;
import electric.util.string.Strings;
import electric.util.string.Tokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class InboundHTTPRequest
implements HttpServletRequest,
IHTTPConstants {
    private static final Hashtable NO_ATTRIBUTES = new Hashtable();
    private static final Hashtable NO_PARAMETERS = new Hashtable();
    private IChannel channel;
    private Config config;
    private String version;
    private String method;
    private String uri;
    private String query;
    private MIMEHeaders headers = new MIMEHeaders();
    private Hashtable attributes = NO_ATTRIBUTES;
    private Hashtable parameters;
    private HTTPSession session;
    private OutboundHTTPResponse httpResponse;
    private ServletInputStream inputStream;
    private String user;
    private String pathInfo;
    private String servletPath;
    private Vector locales;
    private boolean isSecure;
    private String scheme = "http";

    public InboundHTTPRequest() {
    }

    public InboundHTTPRequest(IChannel channel) {
        this.channel = channel;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.method).append(' ').append(this.uri);
        if (this.query != null) {
            buffer.append('?').append(this.query);
        }
        buffer.append(' ').append(this.version).append('\n');
        buffer.append(this.headers.toString());
        return buffer.toString();
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public void setChannel(IChannel channel) {
        this.channel = channel;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setHTTPResponse(OutboundHTTPResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.uri;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.uri);
    }

    public String getQueryString() {
        return this.query;
    }

    public int getContentLength() {
        return this.headers.getContentLength();
    }

    public String getContentType() {
        return this.headers.getContentType();
    }

    public void setContentType(String type) {
        this.headers.setContentType(type);
    }

    public void setCharacterEncoding(String newEncoding) throws UnsupportedEncodingException {
        this.headers.setCharacterEncoding(newEncoding);
    }

    public String getCharacterEncoding() {
        return this.headers.getCharacterEncoding();
    }

    public void readHeaders() throws IOException {
        InputStream input = this.channel.getInputStream();
        String command = Streams.readLine(input, StringEncodings.getProtocolEncoding());
        this.parseCommand(command);
        this.headers.readHeaders(input);
        this.processContinue(input);
    }

    private void parseCommand(String command) {
        Tokenizer tokenizer = new Tokenizer(command);
        this.method = tokenizer.nextToken();
        this.uri = tokenizer.nextToken();
        int question = this.uri.indexOf(63);
        if (question != -1) {
            this.query = this.uri.substring(question + 1);
            this.uri = this.uri.substring(0, question);
        }
        if (this.uri.indexOf("://") != -1) {
            int index = this.uri.indexOf("://") + 3;
            int slash = this.uri.indexOf(47, index);
            this.uri = slash == -1 ? "/" : this.uri.substring(slash);
        }
        this.uri = HTTPUtil.decode(this.uri);
        this.version = tokenizer.nextToken();
    }

    private void processContinue(InputStream input) throws IOException {
        String expectHeader = this.getHeader("Expect");
        if (expectHeader == null || !expectHeader.equals("100-continue") || input.available() > 0) {
            return;
        }
        OutputStream writer = this.channel.getOutputStream();
        writer.write(IHTTPConstants.CONTINUATION_STATUS);
        writer.flush();
    }

    public MIMEHeaders getHeaders() {
        return this.headers;
    }

    public void clearHeaders() {
        this.headers.clearHeaders();
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.headers.getIntHeader(name);
    }

    public long getDateHeader(String name) {
        return this.headers.getDateHeader(name);
    }

    public boolean isKeepAlive() {
        String connection = this.getHeader("Connection");
        if (this.getVersion().equals("HTTP/1.0")) {
            return connection != null && connection.equalsIgnoreCase("Keep-Alive");
        }
        return connection == null || !connection.equalsIgnoreCase("Close");
    }

    public synchronized Enumeration getLocales() {
        if (this.locales == null) {
            this.locales = RequestLocales.getSortedLocales(this);
        }
        return this.locales.elements();
    }

    public Locale getLocale() {
        Enumeration locales = this.getLocales();
        if (locales.hasMoreElements()) {
            return (Locale)this.getLocales().nextElement();
        }
        return null;
    }

    public synchronized Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public synchronized Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public synchronized void removeAttribute(String name) {
        if (name != null) {
            this.attributes.remove(name);
        }
    }

    public synchronized void setAttribute(String name, Object value) {
        if (name == null) {
            return;
        }
        if (this.attributes == NO_ATTRIBUTES) {
            this.attributes = new Hashtable();
        }
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        String[] values = this.getParameterValues(name);
        return values == null ? null : values[0];
    }

    public Enumeration getParameterNames() {
        return this.getParameters().keys();
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        return (String[])this.getParameters().get(name);
    }

    public Map getParameterMap() {
        return this.getParameters();
    }

    private synchronized Hashtable getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        try {
            String contentType;
            if (this.query != null) {
                this.parameters = new Hashtable();
                HTTPUtil.addParameters(this.parameters, this.query);
            }
            if ((contentType = this.getContentType()) != null) {
                contentType = contentType.toLowerCase();
            }
            if (this.method.equalsIgnoreCase("POST") && this.getContentLength() > 0 && contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
                if (this.parameters == null) {
                    this.parameters = new Hashtable();
                }
                String paramsString = StringEncodings.fromProtocolEncoding(Streams.readFully((InputStream)this.getInputStream(), this.getContentLength()));
                HTTPUtil.addParameters(this.parameters, paramsString);
            }
        }
        catch (IOException exception) {
            // empty catch block
        }
        if (this.parameters == null) {
            this.parameters = NO_PARAMETERS;
        }
        return this.parameters;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        RequestDispatcher dispatcher = null;
        HTTPContext context = this.config.getContext();
        if (path.startsWith("/")) {
            dispatcher = context.getRequestDispatcher(path);
        } else {
            int lastSlashPos = this.servletPath.lastIndexOf("/");
            path = lastSlashPos == -1 || lastSlashPos == 0 ? "/" + path : Strings.splice(Strings.head(this.servletPath, '/'), path);
            dispatcher = context.getRequestDispatcher(path);
        }
        return dispatcher;
    }

    public Cookie[] getCookies() {
        String cookies = this.getHeader("Cookie");
        return cookies == null ? null : Cookies.getCookies(cookies);
    }

    public Cookie getCookie(String name) {
        if (name == null) {
            return null;
        }
        return Cookies.getCookie(this.getCookies(), name);
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public synchronized HttpSession getSession(boolean createIfNotFound) {
        if (this.session != null && this.session.isValid()) {
            this.session.accessed();
            return this.session;
        }
        Cookie cookie = this.getCookie("TME-GLUE-Session");
        HTTPContext context = this.config.getContext();
        if (cookie != null) {
            this.session = context.getSession(cookie.getValue());
        }
        if (this.session != null) {
            this.session.accessed();
        } else if (createIfNotFound) {
            this.session = context.newSession();
            cookie = new Cookie("TME-GLUE-Session", this.session.getId());
            cookie.setVersion(0);
            String path = this.config.getContext().getPath();
            cookie.setPath(path.equals("") ? "/" : path);
            cookie.setMaxAge(-1);
            this.httpResponse.addCookie(cookie);
        }
        return this.session;
    }

    public String getRemoteUser() {
        return this.user;
    }

    public void setRemoteUser(String user) {
        this.user = user;
    }

    public boolean isUserInRole(String role) {
        if (this.user == null) {
            return false;
        }
        return this.config.getContext().getRealm().isUserInRole(this.user, new String[]{role});
    }

    public Principal getUserPrincipal() {
        if (this.user == null) {
            return null;
        }
        return this.config.getContext().getRealm().getPrincipal(this.user);
    }

    public String getAuthType() {
        return this.config.getContext().getAuthMethod();
    }

    public String getContextPath() {
        return this.config.getContext().getPath();
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getRealPath(String path) {
        return this.config.getContext().getRealPath(path);
    }

    public String getPathTranslated() {
        return this.config.getContext().getRealPath(this.getPathInfo());
    }

    public String getRemoteAddr() {
        return this.channel.getRemoteXURL().getHost();
    }

    public String getRemoteHost() {
        return this.getHostName(this.channel.getRemoteXURL());
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServerName() {
        return this.getHostName(this.channel.getLocalXURL());
    }

    public int getServerPort() {
        return this.channel.getLocalXURL().getPort();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public String getProtocol() {
        return this.version;
    }

    private String getHostName(XURL xurl) {
        try {
            return InetAddress.getByName(xurl.getHost()).getHostName();
        }
        catch (Throwable throwable) {
            return xurl.getHost();
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        this.inputStream = new ServletInput(this.getChannelInputStream());
        return this.inputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.inputStream != null) {
            throw new IllegalStateException("cannot call getReader, ServletInputStream already obtained");
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            return new BufferedReader(new InputStreamReader(this.channel.getInputStream()));
        }
        return new BufferedReader(new InputStreamReader(this.channel.getInputStream(), encoding));
    }

    private InputStream getChannelInputStream() throws IOException {
        String transferEncoding = this.getHeader("Transfer-Encoding");
        if (transferEncoding != null && transferEncoding.toLowerCase().startsWith("chunked")) {
            return new ChunkedInputStream(this.channel.getInputStream());
        }
        return this.channel.getInputStream();
    }
}

