/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet;

import electric.servlet.ContextComparator;
import electric.servlet.HTTPContext;
import electric.util.array.ArrayUtil;
import electric.util.sorting.BubbleSort;
import electric.webserver.WebServer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class ServletEngine {
    private static final ContextComparator contextComparator = new ContextComparator();
    private WebServer webServer;
    private HTTPContext[] contexts = new HTTPContext[0];

    public ServletEngine(WebServer webServer) {
        this.setWebServer(webServer);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setWebServer(WebServer webServer) {
        this.webServer = webServer;
    }

    public HTTPContext service(String uri, ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HTTPContext context = this.getContext(uri);
        if (context == null) {
            return null;
        }
        context.service(uri, request, response);
        response.flushBuffer();
        return context;
    }

    public void addContext(String path, HTTPContext context) throws ServletException {
        this.addContext(path, context, true);
    }

    public synchronized void addContext(String path, HTTPContext context, boolean startup) throws ServletException {
        context.setServletEngine(this);
        context.setPath(path);
        path = context.getPath();
        int i = 0;
        while (i < this.contexts.length) {
            if (this.contexts[i].getPath().equals(path)) {
                this.contexts[i].shutdown();
                this.contexts[i] = context;
                if (startup) {
                    context.startup();
                }
                return;
            }
            ++i;
        }
        this.addContext(context);
        BubbleSort.sort(this.contexts, contextComparator);
        if (startup) {
            context.startup();
        }
    }

    private void addContext(HTTPContext context) {
        this.contexts = (HTTPContext[])ArrayUtil.addElement(this.contexts, context);
    }

    public synchronized HTTPContext removeContext(String path) {
        HTTPContext context = this.getContext(path);
        if (context == null) {
            return null;
        }
        this.removeContext(context);
        context.shutdown();
        return context;
    }

    private void removeContext(HTTPContext context) {
        this.contexts = (HTTPContext[])ArrayUtil.removeElement(this.contexts, context);
    }

    public HTTPContext getContext(String path) {
        if (path.equals("")) {
            path = "/";
        }
        int i = 0;
        while (i < this.contexts.length) {
            int length;
            HTTPContext context = this.contexts[i];
            if (path.startsWith(context.getPath()) && ((length = context.getPath().length()) == 1 || path.length() == length || path.charAt(length) == '/')) {
                return context;
            }
            ++i;
        }
        return null;
    }

    public HTTPContext[] getAllContexts() {
        return this.contexts;
    }

    public void shutdown() {
        int i = 0;
        while (i < this.contexts.length) {
            this.contexts[i].shutdown();
            ++i;
        }
    }
}

