/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet;

import electric.servlet.Config;
import electric.servlet.MappedServlet;
import electric.util.array.ArrayUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ServletMapper {
    private Hashtable mappings = new Hashtable();
    private Hashtable cachedMappings = new Hashtable();
    private int maxCacheSize = -1;

    public synchronized String[] getServletMappings(Config servletConfig) {
        String[] array = new String[]{};
        Enumeration enumeration = this.mappings.keys();
        while (enumeration.hasMoreElements()) {
            String urlPattern = (String)enumeration.nextElement();
            if (this.mappings.get(urlPattern) != servletConfig) continue;
            array = (String[])ArrayUtil.addElement(array, urlPattern);
        }
        return array;
    }

    public synchronized void addServletMapping(Config servletConfig, String urlPattern) {
        this.mappings.put(urlPattern, servletConfig);
        this.clearCache();
    }

    public synchronized void removeServletMapping(Config servletConfig, String urlPattern) {
        if (urlPattern == null) {
            return;
        }
        this.mappings.remove(urlPattern);
    }

    public synchronized void removeAllMappings(Config servletConfig) {
        if (servletConfig == null) {
            return;
        }
        Vector patternList = new Vector();
        Enumeration patterns = this.mappings.keys();
        while (patterns.hasMoreElements()) {
            patternList.addElement(patterns.nextElement());
        }
        int i = 0;
        while (i < patternList.size()) {
            String pattern = (String)patternList.elementAt(i);
            Config config = this.getServletMapping(pattern);
            if (config == servletConfig) {
                this.mappings.remove(pattern);
            }
            ++i;
        }
        this.clearCache();
    }

    public Hashtable getServletMappings() {
        return (Hashtable)this.mappings.clone();
    }

    public Config getServletMapping(String urlPattern) {
        return (Config)this.mappings.get(urlPattern);
    }

    public void clearCache() {
        this.cachedMappings.clear();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    private void cacheMapping(String path, MappedServlet mappedServlet) {
        if (this.maxCacheSize == 0 || this.maxCacheSize != -1 && this.cachedMappings.size() >= this.maxCacheSize) {
            return;
        }
        this.cachedMappings.put(path, mappedServlet);
    }

    public MappedServlet mapPathToServlet(String path) {
        MappedServlet mappedServlet = null;
        if (this.maxCacheSize != 0 && (mappedServlet = (MappedServlet)this.cachedMappings.get(path)) != null) {
            return mappedServlet;
        }
        mappedServlet = this.mapPathToServletNoCache(path);
        if (mappedServlet != null && this.maxCacheSize != 0) {
            this.cacheMapping(path, mappedServlet);
        }
        return mappedServlet;
    }

    public MappedServlet mapPathToServletNoCache(String path) {
        if (path == null) {
            return null;
        }
        MappedServlet mappedServlet = this.findExactMatch(path);
        if (mappedServlet != null) {
            return mappedServlet;
        }
        mappedServlet = this.findPrefixMatch(path);
        if (mappedServlet != null) {
            return mappedServlet;
        }
        mappedServlet = this.findSuffixMatch(path);
        if (mappedServlet != null) {
            return mappedServlet;
        }
        return this.findDefault(path);
    }

    protected MappedServlet findExactMatch(String path) {
        Config servletConfig = (Config)this.mappings.get(path);
        if (servletConfig != null) {
            return new MappedServlet(servletConfig, path, null);
        }
        return null;
    }

    protected MappedServlet findPrefixMatch(String path) {
        int slash;
        Config servletConfig = null;
        String servletPath = path;
        while ((servletConfig = (Config)this.mappings.get(servletPath + "/*")) == null && (slash = servletPath.lastIndexOf(47)) >= 0) {
            servletPath = servletPath.substring(0, slash);
        }
        if (servletConfig != null) {
            String pathInfo = path.substring(servletPath.length());
            return new MappedServlet(servletConfig, servletPath, pathInfo);
        }
        return null;
    }

    protected MappedServlet findSuffixMatch(String path) {
        int lastSlashPos = path.lastIndexOf(47);
        String lastPathSegment = null;
        lastPathSegment = lastSlashPos != -1 ? path.substring(lastSlashPos) : path;
        int dotPos = lastPathSegment.lastIndexOf(46);
        if (dotPos != -1) {
            String suffix = lastPathSegment.substring(dotPos + 1);
            String pattern = "*." + suffix;
            Config servletConfig = (Config)this.mappings.get(pattern);
            if (servletConfig != null) {
                return new MappedServlet(servletConfig, path, null);
            }
        }
        return null;
    }

    protected MappedServlet findDefault(String path) {
        Config servletConfig = (Config)this.mappings.get("/");
        if (servletConfig != null) {
            return new MappedServlet(servletConfig, path, null);
        }
        return null;
    }
}

