/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.authorizers.siteminder;

import electric.glue.IGLUELoggingConstants;
import electric.security.credentials.PasswordCredentials;
import electric.servlet.authenticators.basic.BasicAuthenticator;
import electric.servlet.authorizers.IHTTPAuthorizer;
import electric.servlet.authorizers.siteminder.NameRealm;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.log.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import netegrity.siteminder.javaagent.AgentAPI;
import netegrity.siteminder.javaagent.Attribute;
import netegrity.siteminder.javaagent.AttributeList;
import netegrity.siteminder.javaagent.InitDef;
import netegrity.siteminder.javaagent.RealmDef;
import netegrity.siteminder.javaagent.ResourceContextDef;
import netegrity.siteminder.javaagent.ServerDef;
import netegrity.siteminder.javaagent.SessionDef;
import netegrity.siteminder.javaagent.UserCredentials;

public class SiteMinderAuthorizer
implements IHTTPAuthorizer,
IHTTPConstants,
IGLUELoggingConstants {
    private AgentAPI agent;
    private BasicAuthenticator authenticator = new BasicAuthenticator();
    private String policyServerAddress;
    private int authorizationPort = 44443;
    private int authenticationPort = 44442;
    private int accountingPort = 44442;
    private String agentName = "gaia";
    private String sharedSecret = "electric";
    private long SITEMINDER_EVENT = Log.getCode("SITEMINDER");
    private long SITEMINDER_DEBUG_EVENT = Log.getCode("SITEMINDER_DEBUG");

    public SiteMinderAuthorizer() {
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderAuthorizer.SiteMinderAuthorizer()");
        }
    }

    public void init() {
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderAuthorizer.init()");
        }
        this.connect();
    }

    public String getPolicyServerAddress() {
        return this.policyServerAddress;
    }

    public void setPolicyServerAddress(String policyServerAddress) {
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)("SiteMinderAuthorizer.setPolicyServerAddress(" + policyServerAddress + ")"));
        }
        this.policyServerAddress = policyServerAddress;
    }

    public int getAuthorizationPort() {
        return this.authorizationPort;
    }

    public void setAuthorizationPort(int authorizationPort) {
        this.authorizationPort = authorizationPort;
    }

    public int getAuthenticationPort() {
        return this.authenticationPort;
    }

    public void setAuthenticationPort(int authenticationPort) {
        this.authenticationPort = authenticationPort;
    }

    public int getAccountingPort() {
        return this.accountingPort;
    }

    public void setAccountingPort(int accountingPort) {
        this.accountingPort = accountingPort;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public void connect() {
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderAuthorizer.connect()");
        }
        ServerDef serverDef = new ServerDef();
        serverDef.serverIpAddress = this.policyServerAddress;
        serverDef.connectionMin = 1;
        serverDef.connectionMax = 1;
        serverDef.connectionStep = 1;
        serverDef.timeout = 20;
        serverDef.authorizationPort = this.authorizationPort;
        serverDef.authenticationPort = this.authenticationPort;
        serverDef.accountingPort = this.accountingPort;
        InitDef id = new InitDef(this.agentName, this.sharedSecret, false, serverDef);
        this.agent = new AgentAPI();
        int result = this.agent.init(id);
        if (result != 0) {
            if (Log.isLogging(this.SITEMINDER_EVENT)) {
                Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)("SiteMinderAuthorizer.connect():connect failed:" + result));
            }
            return;
        }
    }

    public boolean authorize(HttpServletRequest request, HttpServletResponse response, String relativePath) throws IOException {
        if (this.agent == null) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                Log.log("SiteMinderAuthorizer.authorize():siteminder initialization problem, failsafe mode, all requests fail");
            }
            response.sendError(500);
            return false;
        }
        String queryString = request.getQueryString();
        if (queryString == null) {
            if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
                Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderAuthorizer.authorize():no query string, assume unprotected");
            }
            return true;
        }
        String wsdlUrl = HTTPUtil.getParameter(queryString, "service.wsdl");
        if (wsdlUrl == null) {
            if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
                Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderAuthorizer.authorize():no serivce.wsdl, assume unprotected");
            }
            return true;
        }
        String clientIP = request.getRemoteAddr();
        XURL wsdlXurl = new XURL(wsdlUrl);
        RealmDef realmDef = this.isProtected(wsdlXurl.getFile(), clientIP);
        if (realmDef == null) {
            if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
                Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderAuthorizer.authorize():no realm, unprotected");
            }
            return true;
        }
        SessionDef session = this.authenticate(request, response, wsdlXurl.getFile(), realmDef);
        if (session == null) {
            return false;
        }
        AttributeList attributes = new AttributeList();
        ResourceContextDef resourceContext = new ResourceContextDef("", "", wsdlXurl.getFile(), "POST");
        String transactionID = "";
        int result = this.agent.authorize(clientIP, transactionID, resourceContext, realmDef, session, attributes);
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)("SiteMinderAuthorizer.authorize():agent.isAuthorized()=" + result));
        }
        if (result != 1) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"SiteminderAuthorizer.authorize():siteminder says not authorized");
            }
            response.sendError(401, "Access Denied");
            return false;
        }
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT) && Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderAuthorizer.authorize():siteminder says authorized");
            SiteMinderAuthorizer.printSession(this.SITEMINDER_DEBUG_EVENT, session);
            SiteMinderAuthorizer.printAttributes(this.SITEMINDER_DEBUG_EVENT, attributes);
        }
        return true;
    }

    private PasswordCredentials getCredentials(HttpServletRequest httpRequest) {
        String authHeader = httpRequest.getHeader("Authorization");
        if (authHeader == null) {
            return null;
        }
        PasswordCredentials[] credentials = this.authenticator.getCredentials(authHeader);
        if (credentials == null || credentials.length == 0) {
            return null;
        }
        return credentials[0];
    }

    private RealmDef isProtected(String resourcePath, String clientIP) {
        ResourceContextDef resourceContext = new ResourceContextDef("", "", resourcePath, "POST");
        RealmDef realm = new RealmDef();
        int result = this.agent.isProtected(clientIP, resourceContext, realm);
        if (result == 2) {
            if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
                Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)("SiteMinderReference.authorize():not protected:" + resourcePath));
            }
            return null;
        }
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)("SiteMinderReference.authorize():protected:[" + realm.name + "]" + resourcePath));
        }
        return realm;
    }

    private SessionDef authenticate(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String resourcePath, RealmDef realm) throws UnknownHostException, IOException {
        PasswordCredentials credentials = this.getCredentials(httpRequest);
        if (credentials == null) {
            if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
                Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderReference.authenticate():no credentials, authc failed, request basic auth");
            }
            this.authenticator.requestAuthentication(httpRequest, httpResponse, new NameRealm(realm.name));
            return null;
        }
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)("SiteMinderReference.authenticate():basic username=" + credentials.getUserName()));
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)("SiteMinderReference.authenticate():basic password=" + credentials.password));
        }
        InetAddress clientAddress = InetAddress.getByName(httpRequest.getRemoteAddr());
        String clientAddressString = clientAddress.getHostAddress();
        ResourceContextDef resourceContext = new ResourceContextDef("", "", resourcePath, "POST");
        UserCredentials userCredentials = new UserCredentials(credentials.getUserName(), credentials.password);
        SessionDef session = new SessionDef();
        AttributeList attributes = new AttributeList();
        int result = this.agent.login(clientAddressString, resourceContext, realm, userCredentials, session, attributes);
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)("SiteMinderReference.authenticate():agent.login=" + result));
        }
        if (result != 1) {
            if (result != 3) {
                if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                    Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"SiteMinderAuthorizer.authenticate():assuming authentication failed");
                }
                httpResponse.sendError(401);
                return null;
            }
            if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT)) {
                Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderAuthorizer.authenticate():siteminder says challenge");
            }
            this.authenticator.requestAuthentication(httpRequest, httpResponse, new NameRealm(realm.name));
            return null;
        }
        if (Log.isLogging(this.SITEMINDER_DEBUG_EVENT) && Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
            Log.log(this.SITEMINDER_DEBUG_EVENT, (Object)"SiteMinderAuthorizer.authenticate():assuming authentication success");
            SiteMinderAuthorizer.printSession(this.SITEMINDER_DEBUG_EVENT, session);
            SiteMinderAuthorizer.printAttributes(this.SITEMINDER_DEBUG_EVENT, attributes);
        }
        return session;
    }

    public static void printAttributes(long logChannel, AttributeList attributes) {
        Log.log(logChannel, (Object)"Attributes:");
        if (attributes == null) {
            return;
        }
        Enumeration e = attributes.attributes();
        while (e.hasMoreElements()) {
            Attribute attribute = (Attribute)e.nextElement();
            Log.log(logChannel, (Object)("   " + attribute.id + ":" + new String(attribute.value) + "," + attribute.ttl + "," + attribute.oid));
        }
    }

    public static void printSession(long logChannel, SessionDef session) {
        Log.log(logChannel, (Object)("session: " + session));
        if (session == null) {
            return;
        }
        Log.log(logChannel, (Object)("session id is: " + session.id));
        Log.log(logChannel, (Object)("session spec is: " + session.spec));
        Log.log(logChannel, (Object)("session time: " + session.currentServerTime));
        Log.log(logChannel, (Object)("session time: " + System.currentTimeMillis() / 1000L));
        Log.log(logChannel, (Object)("session time: " + session.idleTimeout));
        Log.log(logChannel, (Object)("session time: " + session.maxTimeout));
    }
}

