/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.httpget;

import electric.servlet.webinf.IWebInfConstants;
import electric.util.array.ArrayUtil;
import electric.util.http.IHTTPConstants;
import electric.util.mime.MIMETypes;
import electric.util.string.Strings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HTTPGetServlet
extends HttpServlet
implements IHTTPConstants,
IWebInfConstants {
    private static int BUFFER_SIZE = 16384;
    private static String[] defaultWelcomeFiles;
    private static boolean dirListing;
    private ServletContext context;
    private String[] welcomeFiles = new String[0];

    public HTTPGetServlet() {
        this.initWelcomeFiles();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Server", IHTTPConstants.SERVER_TYPE);
        response.setDateHeader("Date", new Date().getTime());
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String uri = request.getPathInfo();
        if (uri == null) {
            uri = request.getServletPath();
        }
        if (this.context == null) {
            response.sendError(404, "cannot find " + uri);
            return;
        }
        if (uri == null || uri.trim().equals("") || uri.trim().equals("/")) {
            int i = 0;
            while (i < this.welcomeFiles.length) {
                if (new File(this.context.getRealPath(this.welcomeFiles[i])).exists() || this.welcomeFiles[i].indexOf(".") == -1) {
                    String destination = Strings.splice(Strings.splice(contextPath, servletPath), this.welcomeFiles[i]);
                    response.sendRedirect(destination);
                    return;
                }
                ++i;
            }
            response.sendError(404, "cannot find welcome file");
            return;
        }
        if ((uri = this.context.getRealPath(uri)).toUpperCase().indexOf("WEB-INF") != -1) {
            response.sendError(403, "access to " + uri + " is forbidden");
            return;
        }
        File file = new File(uri);
        if (!file.exists()) {
            response.sendError(404, "cannot find " + uri);
            response.setContentType("text/html");
            PrintWriter writer = response.getWriter();
            writer.println("<html><body><h2>");
            writer.println("<p>File not found:</p>");
            writer.println("<tt>" + request.getRequestURI() + "</tt>");
            writer.println("<h2></body></html>");
            return;
        }
        if (file.isDirectory()) {
            int i = 0;
            while (i < this.welcomeFiles.length) {
                if (new File(file, this.welcomeFiles[i]).exists()) {
                    String destination = Strings.splice(contextPath, servletPath);
                    destination = Strings.splice(destination, request.getPathInfo());
                    destination = Strings.splice(destination, this.welcomeFiles[i]);
                    response.sendRedirect(destination);
                    return;
                }
                ++i;
            }
            if (dirListing) {
                this.generateDirListing(file, response);
            } else {
                response.sendError(404, "cannot find " + uri);
            }
            return;
        }
        long lastModified = file.lastModified();
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifModifiedSince != -1L && lastModified / 1000L <= ifModifiedSince / 1000L) {
            response.setStatus(304);
        } else {
            String range = request.getHeader("Range");
            RandomAccessFile randomfile = new RandomAccessFile(file, "r");
            try {
                this.copyFile(randomfile, range, response, file.getName(), file.lastModified());
                Object var14_16 = null;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                randomfile.close();
                throw throwable;
            }
            randomfile.close();
            {
            }
        }
    }

    private void copyFile(RandomAccessFile file, String range, HttpServletResponse response, String name, long lastModified) throws IOException {
        long length = file.length();
        long[][] ranges = this.getRanges(range, length);
        long total = 0L;
        int i = 0;
        while (i < ranges.length) {
            total += ranges[i][2];
            ++i;
        }
        response.setDateHeader("Last-Modified", lastModified);
        response.setContentLength((int)total);
        String contentType = this.context.getMimeType(name);
        if (contentType == null) {
            String ext = Strings.extension(name);
            contentType = MIMETypes.getMimeType(ext);
        }
        if (contentType == null) {
            contentType = MIMETypes.getDefaultMimeType();
        }
        response.setContentType(contentType);
        response.addHeader("Accept-Ranges", "bytes");
        response.setStatus(200);
        byte[] buffer = new byte[BUFFER_SIZE];
        ServletOutputStream stream = response.getOutputStream();
        int i2 = 0;
        while (i2 < ranges.length) {
            int bytes;
            file.seek(ranges[i2][0]);
            long amount = ranges[i2][2];
            do {
                bytes = file.read(buffer);
                stream.write(buffer, 0, bytes);
            } while ((amount -= (long)bytes) > 0L);
            ++i2;
        }
    }

    public static void setDefaultWelcomeFiles(String[] defaultWelcomeFiles) {
        HTTPGetServlet.defaultWelcomeFiles = defaultWelcomeFiles;
    }

    private void initWelcomeFiles() {
        if (defaultWelcomeFiles != null) {
            int i = 0;
            while (i < defaultWelcomeFiles.length) {
                this.addWelcomeFile(defaultWelcomeFiles[i]);
                ++i;
            }
        }
        if (this.welcomeFiles.length == 0) {
            this.addWelcomeFile("index.html");
            this.addWelcomeFile("index.htm");
            this.addWelcomeFile("index.jsp");
        }
    }

    public void addWelcomeFile(String filename) {
        this.welcomeFiles = (String[])ArrayUtil.addElement(this.welcomeFiles, filename);
    }

    public void removeWelcomeFile(String filename) {
        this.welcomeFiles = (String[])ArrayUtil.removeElement(this.welcomeFiles, filename);
    }

    private long[][] getRanges(String value, long length) {
        if (value == null) {
            return new long[][]{{0L, length - 1L, length}};
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        int tokens = tokenizer.countTokens();
        long[][] ranges = new long[tokens][3];
        int i = 0;
        while (i < tokens) {
            String string = tokenizer.nextToken().trim();
            int index = string.indexOf(45);
            if (index == 0) {
                ranges[i][0] = length - Long.parseLong(string.substring(1));
                ranges[i][1] = length - 1L;
            } else if (index == string.length() - 1) {
                ranges[i][0] = Long.parseLong(string.substring(0, string.length() - 2));
                ranges[i][1] = length - 1L;
            } else {
                ranges[i][0] = Long.parseLong(string.substring(0, index));
                ranges[i][1] = Long.parseLong(string.substring(index + 1));
            }
            ranges[i][2] = ranges[i][1] - ranges[i][0] + 1L;
            ++i;
        }
        return ranges;
    }

    public static void setBufferSize(int bufferSize) {
        BUFFER_SIZE = bufferSize;
    }

    public static int getBufferSize() {
        return BUFFER_SIZE;
    }

    public static void enableDirectoryListing(boolean dirListing) {
        HTTPGetServlet.dirListing = dirListing;
    }

    private void generateDirListing(File directory, HttpServletResponse response) throws IOException {
        response.sendError(501, "directory listing is currently not supported");
    }
}

