/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.handlers.interceptor;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.handlers.chain.ChainedSOAPHandler;
import electric.soap.util.SOAPInterceptors;
import electric.util.Context;
import java.rmi.RemoteException;

public class SOAPInterceptorHandler
extends ChainedSOAPHandler
implements ISOAPConstants,
IGLUELoggingConstants,
IGLUEContextConstants {
    private IService service;

    public SOAPInterceptorHandler(IService service, ISOAPHandler nextHandler) {
        super(nextHandler);
        this.service = service;
    }

    public String toString() {
        return this.service.toString();
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        try {
            SOAPInterceptors.callInterceptors(this.service.getContext(), messageContext, "inboundSoapRequestInterceptor", request);
            if (request.isException()) {
                throw request.getException();
            }
            SOAPMessage response = this.nextHandler.handle(request, messageContext);
            SOAPInterceptors.callInterceptors(this.service.getContext(), messageContext, "outboundSoapResponseInterceptor", response);
            return response;
        }
        catch (Throwable exception) {
            return new SOAPMessage(exception);
        }
    }
}

