/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.handlers.logging;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.handlers.chain.ChainedSOAPHandler;
import electric.util.Context;
import electric.util.XURL;
import electric.util.log.Log;
import java.rmi.RemoteException;

public final class SOAPLoggingHandler
extends ChainedSOAPHandler
implements ISOAPConstants,
IGLUELoggingConstants,
IGLUEContextConstants {
    private IService service;

    public SOAPLoggingHandler(IService service, ISOAPHandler nextHandler) {
        super(nextHandler);
        this.service = service;
    }

    public String toString() {
        return this.service.toString();
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        XURL endpoint = (XURL)messageContext.getProperty("endpoint");
        if (Log.isLogging(IGLUELoggingConstants.SOAP_EVENT)) {
            Log.log(IGLUELoggingConstants.SOAP_EVENT, (Object)("request for " + endpoint + "\n" + request + "\n"));
        }
        SOAPMessage response = this.nextHandler.handle(request, messageContext);
        if (Log.isLogging(IGLUELoggingConstants.SOAP_EVENT)) {
            Log.log(IGLUELoggingConstants.SOAP_EVENT, (Object)("response from " + endpoint + "\n" + response + "\n"));
        }
        return response;
    }
}

