/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.http.reference;

import electric.glue.IGLUELoggingConstants;
import electric.http.InboundHTTPResponse;
import electric.http.OutboundHTTPRequest;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.util.array.ByteArray;
import electric.util.http.IHTTPConstants;
import electric.util.io.ArraySource;
import electric.util.io.Streams;
import electric.wsdl.WSDL;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class ClientNoAttachments
implements ISOAPConstants,
IGLUELoggingConstants,
IHTTPConstants {
    public static void populateRequest(SOAPMessage soapRequest, OutboundHTTPRequest httpRequest, WSDL wsdl, Enumeration unreferencedAttachments) throws IOException {
        String soapVersion = soapRequest.getSoapVersion();
        if (soapVersion != null && soapVersion.equals("http://www.w3.org/2003/05/soap-envelope")) {
            httpRequest.setContentType("application/soap+xml");
        } else if (!soapRequest.getOptimizations().hasOptimizations()) {
            httpRequest.setContentType("text/xml; charset=UTF-8");
        }
        ByteArray byteArray = soapRequest.getByteArray(wsdl);
        ArraySource source = new ArraySource(byteArray, IGLUELoggingConstants.HTTP_EVENT);
        httpRequest.setSource(source);
    }

    public static SOAPMessage readResponse(InboundHTTPResponse httpResponse, SOAPOptimizations optimizations, WSDL wsdl) throws IOException, ParseException {
        InputStream httpInput = httpResponse.getInputStream();
        int httpContentLength = httpResponse.getContentLength();
        byte[] bytes = Streams.readFully(httpInput, httpContentLength, IGLUELoggingConstants.HTTP_EVENT);
        SOAPMessage soapMessage = new SOAPMessage();
        String contentType = httpResponse.getContentType();
        if (contentType != null && contentType.startsWith("application/soap+xml")) {
            soapMessage.setSoapVersion("http://www.w3.org/2003/05/soap-envelope");
        }
        soapMessage.setBytes(bytes, optimizations, wsdl);
        return soapMessage;
    }
}

