/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.http.reference;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ProxyContext;
import electric.glue.context.ThreadContext;
import electric.http.HTTPMessage;
import electric.http.InboundHTTPResponse;
import electric.http.OutboundHTTPRequest;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.http.reference.ClientDIME;
import electric.soap.http.reference.ClientMIME;
import electric.soap.http.reference.ClientNoAttachments;
import electric.soap.references.ISOAPReference;
import electric.util.Context;
import electric.util.XURL;
import electric.util.dime.IDIMEConstants;
import electric.util.encoding.StringEncodings;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.log.Log;
import electric.wsdl.WSDL;
import electric.xml.ParseException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Enumeration;

public final class SOAPToHTTP
implements ISOAPReference,
IHTTPConstants,
IGLUELoggingConstants,
ISOAPConstants,
IDIMEConstants,
IGLUEContextConstants {
    private static int MAX_TRIES = 2;
    private XURL endpoint;
    private WSDL wsdl;
    private Context proxyContext;

    public SOAPToHTTP(XURL endpoint) {
        this.endpoint = endpoint;
        this.proxyContext = new ProxyContext();
    }

    public SOAPToHTTP(XURL endpoint, WSDL wsdl, Context proxyContext) {
        this.endpoint = endpoint;
        this.wsdl = wsdl;
        this.proxyContext = proxyContext;
    }

    public String toString() {
        return "SOAPToHTTP( " + this.endpoint + " )";
    }

    public static void setMaxRetries(int maxRetries) {
        MAX_TRIES = maxRetries;
    }

    public static int getMaxRetries() {
        return MAX_TRIES;
    }

    public WSDL getWSDL() {
        return this.wsdl;
    }

    public XURL getEndpoint() {
        return this.endpoint;
    }

    public ISOAPReference next() {
        return null;
    }

    public void setNext(ISOAPReference reference) {
    }

    public SOAPMessage handle(SOAPMessage soapRequest, Context messageContext) throws RemoteException, SecurityException {
        try {
            return this.invoke(soapRequest, messageContext);
        }
        catch (SecurityException exception) {
            throw exception;
        }
        catch (RemoteException exception) {
            throw exception;
        }
        catch (ConnectException exception) {
            throw new java.rmi.ConnectException("url = " + this.endpoint.toString());
        }
        catch (UnknownHostException exception) {
            throw new java.rmi.UnknownHostException("url = " + this.endpoint.toString());
        }
        catch (NoRouteToHostException exception) {
            throw new java.rmi.UnknownHostException("url = " + this.endpoint.toString());
        }
        catch (Exception exception) {
            if (Log.isLogging("EXCEPTION")) {
                Log.log("EXCEPTION", (Throwable)exception);
            }
            throw new RemoteException(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPMessage invoke(SOAPMessage soapRequest, Context messageContext) throws IOException, ParseException, SecurityException {
        SOAPMessage sOAPMessage;
        Enumeration unreferencedAttachments = ThreadContext.removeProperties("unreferencedAttachments");
        OutboundHTTPRequest httpRequest = this.createHTTPRequest(soapRequest);
        messageContext.setProperty("httpRequest", httpRequest);
        httpRequest.setHeader("Connection", HTTPUtil.isKeepAlive(this.proxyContext) ? "Keep-Alive" : "Close");
        this.populateRequest(soapRequest, httpRequest, unreferencedAttachments);
        HTTPMessage httpMessage = new HTTPMessage(httpRequest, this.endpoint, MAX_TRIES, this.proxyContext);
        InboundHTTPResponse httpResponse = httpMessage.send();
        messageContext.setProperty("httpResponse", httpResponse);
        try {
            if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
                Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)("inbound response from " + httpResponse.getHost() + '\n' + httpResponse));
            }
            String contentType = httpResponse.getContentType();
            if (!(httpResponse.isOK() || contentType != null && contentType.toLowerCase().startsWith("text/xml"))) {
                throw new RemoteException("HTTP error response: " + StringEncodings.fromProtocolEncoding(httpResponse.getBytes()));
            }
            SOAPMessage soapResponse = this.readResponse(httpResponse, contentType);
            soapResponse.setContext(messageContext);
            long bytesWritten = httpMessage.getBytesWritten();
            long bytesRead = httpMessage.getBytesRead();
            messageContext.setProperty("bytesWritten", new Long(bytesWritten));
            messageContext.setProperty("bytesRead", new Long(bytesRead));
            sOAPMessage = soapResponse;
            Object var15_12 = null;
        }
        catch (Throwable throwable) {
            Object var15_13 = null;
            httpResponse.close();
            throw throwable;
        }
        httpResponse.close();
        return sOAPMessage;
    }

    private void populateRequest(SOAPMessage soapRequest, OutboundHTTPRequest httpRequest, Enumeration unreferencedAttachments) throws IOException {
        if (soapRequest.hasAttachments() || unreferencedAttachments.hasMoreElements()) {
            String forceAttachmentStyle;
            if (unreferencedAttachments.hasMoreElements() && ((forceAttachmentStyle = ThreadContext.getStringProperty("forceAttachmentStyle")) == null || "dime".equals(forceAttachmentStyle))) {
                soapRequest.setAttachmentStyle("dime");
            }
            if ("dime".equalsIgnoreCase(soapRequest.getAttachmentStyle())) {
                ClientDIME.populateRequest(soapRequest, httpRequest, this.wsdl, unreferencedAttachments);
            } else {
                ClientMIME.populateRequest(soapRequest, httpRequest, this.wsdl, unreferencedAttachments);
            }
        } else {
            ClientNoAttachments.populateRequest(soapRequest, httpRequest, this.wsdl, null);
        }
    }

    private OutboundHTTPRequest createHTTPRequest(SOAPMessage soapRequest) {
        OutboundHTTPRequest httpRequest = new OutboundHTTPRequest();
        httpRequest.setMethod("POST");
        httpRequest.setRequestURI(this.endpoint.getFile());
        httpRequest.setVersion("HTTP/1.1");
        httpRequest.setHeader("Host", this.endpoint.getHost() + ":" + this.endpoint.getPort());
        boolean isKeepAlive = HTTPUtil.isKeepAlive(this.proxyContext);
        httpRequest.setHeader("Connection", isKeepAlive ? "Keep-Alive" : "Close");
        if (soapRequest.getOptimizations().hasOptimizations()) {
            httpRequest.setHeader("GLUEOptimized", soapRequest.getOptimizations().getDescription());
        } else {
            httpRequest.setHeader("User-Agent", IHTTPConstants.SERVER_TYPE);
        }
        if (soapRequest.getMIMEHeaders() != null) {
            httpRequest.getHeaders().addHeaders(soapRequest.getMIMEHeaders());
        }
        return httpRequest;
    }

    private SOAPMessage readResponse(InboundHTTPResponse httpResponse, String contentType) throws IOException, ParseException {
        String optimized = httpResponse.getHeader("GLUEOptimized");
        SOAPOptimizations optimizations = SOAPOptimizations.getSOAPOptimizations(optimized);
        if (HTTPUtil.isMIMEMultipart(contentType)) {
            return ClientMIME.readResponse(httpResponse, optimizations, this.proxyContext, this.wsdl);
        }
        if (HTTPUtil.isDIMEMultipart(contentType)) {
            return ClientDIME.readResponse(httpResponse, optimizations, this.proxyContext, this.wsdl);
        }
        return ClientNoAttachments.readResponse(httpResponse, optimizations, this.wsdl);
    }
}

