/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.local.handlers.service.rpc;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.local.handlers.service.IOperationLookup;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.SOAPOperation;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.IOperation;
import electric.util.reflect.OperationLookup;
import electric.wsdl.Operations;
import electric.wsdl.Service;
import electric.wsdl.WSDL;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;

public final class RPCOperationLookup
implements IOperationLookup,
IGLUELoggingConstants,
ISOAPConstants,
ISchemaConstants,
IGLUEContextConstants {
    private IService service;
    private Operations operations;
    private Namespaces namespaces;
    static /* synthetic */ Class class$electric$util$mime$MIMEData;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPPort;

    public RPCOperationLookup(IService service) {
        this.service = service;
    }

    public SOAPOperation getOperation(SOAPMessage message) throws NoSuchMethodException, RemoteException, IOException, SOAPException {
        Element call = message.getOptimizations().getEnvelopeOmission() ? message.getRoot() : this.getUnoptimizedBody(message);
        this.checkEncoding(message, call);
        boolean isAsync = message.getHeaderElement(SchemaProperties.getTmeNamespace(), "async") != null;
        String methodName = call.getName();
        int argCount = call.getElements().size();
        IOperation[] operations = this.getOperations().getOperations(methodName);
        if (operations.length == 0) {
            throw new NoSuchMethodException("could not find operation corresponding to " + methodName + ". Log MAPPING events to check that client-side map files are being read.");
        }
        if (operations.length == 1) {
            return (SOAPOperation)operations[0];
        }
        if ((operations = OperationLookup.getOperationsWithMoreArguments(operations, argCount, isAsync)).length == 1) {
            return (SOAPOperation)operations[0];
        }
        Elements elements = call.getElements();
        Class[] inArgClasses = new Class[elements.size()];
        try {
            int i = 0;
            while (i < argCount) {
                Type type;
                String href;
                Element child = elements.next();
                String soapEncodingNamespace = null;
                String soapVersion = message.getSoapVersion();
                soapEncodingNamespace = soapVersion != null && soapVersion.equals("http://www.w3.org/2003/05/soap-envelope") ? "http://www.w3.org/2003/05/soap-encoding" : "http://schemas.xmlsoap.org/soap/encoding/";
                String xsiType = child.getAttributeValue(soapEncodingNamespace, "arrayType");
                if (xsiType == null) {
                    xsiType = child.getAttributeValue(this.namespaces.getVersion() + "-instance", "type");
                }
                inArgClasses[i] = xsiType == null ? ((href = child.getAttribute("href")) != null && message.hasAttachment(href) ? (class$electric$util$mime$MIMEData == null ? RPCOperationLookup.class$("electric.util.mime.MIMEData") : class$electric$util$mime$MIMEData) : (class$java$lang$Void == null ? RPCOperationLookup.class$("java.lang.Void") : class$java$lang$Void)) : ((type = this.namespaces.getTypeWithQName(child, xsiType)) == null ? (class$java$lang$Void == null ? RPCOperationLookup.class$("java.lang.Void") : class$java$lang$Void) : type.getJavaClass());
                ++i;
            }
        }
        catch (IOException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new UnmarshalException(exception.toString());
        }
        return (SOAPOperation)OperationLookup.getOperation(operations, methodName, inArgClasses, isAsync);
    }

    private void checkEncoding(SOAPMessage message, Element call) throws SOAPException {
        String encoding = message.getEncodingStyle();
        String style = (String)this.service.getContext().getProperty("style");
        if (style == null) {
            style = SOAPBinding.getDefaultStyle();
        }
        String use = style.equalsIgnoreCase("rpc") ? "encoded" : "literal";
        use = (String)this.service.getContext().getProperty("use", use);
        if (encoding == null) {
            encoding = call.getAttributeValue(message.getEnvelopeNamespace(), "encodingStyle");
        }
        if (encoding == null) {
            encoding = "";
        }
        if (use.equals("literal") && !encoding.equals("")) {
            throw new SOAPException("this is an rpc literal endpoint");
        }
        if (use.equals("encoded") && encoding.equals("")) {
            throw new SOAPException("this is a soap-encoded endpoint");
        }
    }

    private synchronized Operations getOperations() {
        if (this.operations != null) {
            return this.operations;
        }
        WSDL wsdl = this.service.getWSDL();
        Service wsdlService = (Service)wsdl.getServices().nextElement();
        this.operations = wsdlService.getOperations(class$electric$soap$wsdl$SOAPPort == null ? (class$electric$soap$wsdl$SOAPPort = RPCOperationLookup.class$("electric.soap.wsdl.SOAPPort")) : class$electric$soap$wsdl$SOAPPort);
        this.namespaces = wsdl.getNamespaces();
        return this.operations;
    }

    private Element getUnoptimizedBody(SOAPMessage message) throws SOAPException {
        Element body = message.getBody();
        Element possibleBody = null;
        Elements elements = body.getElements();
        while (elements.hasMoreElements()) {
            Element element = elements.next();
            String soapEncodingNamespace = null;
            String soapVersion = message.getSoapVersion();
            soapEncodingNamespace = soapVersion != null && soapVersion.equals("http://www.w3.org/2003/05/soap-envelope") ? "http://www.w3.org/2003/05/soap-encoding" : "http://schemas.xmlsoap.org/soap/encoding/";
            String root = element.getAttributeValue(soapEncodingNamespace, "root");
            if (root == null) {
                if (possibleBody != null) continue;
                possibleBody = element;
                continue;
            }
            if (!root.trim().equals("1")) continue;
            return element;
        }
        if (possibleBody != null) {
            return possibleBody;
        }
        throw new SOAPException("there was no root on the body");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

