/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.references.balance;

import electric.fabric.IFabricConstants;
import electric.soap.references.ISOAPReferenceFactory;
import electric.soap.references.balance.BalanceSOAPReference;
import electric.soap.references.balance.IBalancer;
import electric.soap.references.balance.IBalancerFactory;
import electric.util.Context;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import electric.util.log.ILoggingConstants;
import electric.wsdl.WSDL;
import java.util.Vector;

public final class BalanceSOAPReferenceFactory
implements ISOAPReferenceFactory,
IFabricConstants,
ILoggingConstants {
    private IBalancerFactory balancerFactory;

    public BalanceSOAPReferenceFactory(IBalancerFactory balancerFactory) {
        this.balancerFactory = balancerFactory;
    }

    public boolean newSOAPReference(Vector referenceChain, XURL endpoint, WSDL wsdl, Context proxyContext) {
        if (endpoint.getProtocol() != null) {
            return false;
        }
        String path = endpoint.getFile();
        if (!path.startsWith("?glue")) {
            return false;
        }
        if (!HTTPUtil.hasParameter(path, "balance")) {
            return false;
        }
        path = HTTPUtil.removeParameter(endpoint.getFile(), "balance");
        try {
            IBalancer balancer = this.balancerFactory.newBalancer(path, proxyContext);
            BalanceSOAPReference balanceReference = new BalanceSOAPReference(balancer);
            referenceChain.addElement(balanceReference);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

