/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.registry;

import electric.proxy.IReference;
import electric.registry.IRegistry;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.util.XURL;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.IHasClassLoader;
import electric.util.string.Strings;

public class CrossApplicationRegistry
implements IRegistry {
    public IReference bind(String path, Class[] interfaces, Context context) throws RegistryException {
        ClassLoader cl;
        if (path == null || path.startsWith("?") || XURL.hasProtocol(path)) {
            return null;
        }
        Object object = Registry.get(path);
        if (object instanceof IHasClassLoader && !ClassLoaders.isAncestor(cl = ((IHasClassLoader)object).getClassLoader(), ClassLoaders.getContextClassLoader())) {
            String soapLocalPath = Strings.splice("soaplocal:///", path);
            return Registry.getReference(soapLocalPath, interfaces, context);
        }
        return null;
    }

    public boolean publish(String path, Object object, Context context) throws RegistryException {
        return false;
    }

    public boolean unpublish(String path) throws RegistryException {
        return false;
    }
}

