/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.routing;

import electric.glue.context.ThreadContext;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPMessage;
import electric.soap.references.chain.ChainedSOAPReference;
import electric.soap.routing.IRoutingConstants;
import electric.util.Context;
import electric.util.UUID;
import electric.util.XURL;
import electric.util.string.Strings;
import electric.wsdl.WSDL;
import electric.xml.Element;
import java.rmi.RemoteException;
import java.util.Enumeration;

public class RoutingReference
extends ChainedSOAPReference
implements IRoutingConstants,
ISOAPConstants {
    private Context proxyContext;
    private XURL destination;

    public RoutingReference(Context proxyContext, XURL destination) {
        this.proxyContext = proxyContext;
        this.destination = destination;
    }

    public WSDL getWSDL() {
        return this.nextReference.getWSDL();
    }

    public XURL getEndpoint() {
        return this.nextReference.getEndpoint();
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        Context interceptorContext;
        this.writeHeader(request);
        SOAPMessage response = this.nextReference.handle(request, messageContext);
        Element header = response.getHeaderElement("http://schemas.xmlsoap.org/rp", "path");
        if (header == null) {
            header = response.getHeaderElement("http://schemas.xmlsoap.org/rp/", "path");
        }
        if ((interceptorContext = (Context)ThreadContext.getProperty("interceptorContext")) != null && header != null) {
            interceptorContext.addProperty("understood", header);
        }
        return response;
    }

    public void writeHeader(SOAPMessage request) {
        if (request.getOptimizations().getEnvelopeOmission()) {
            request.deoptimize();
        }
        Element headerElement = request.addHeader();
        String namespace = (String)this.proxyContext.getProperty("rpNamespace", "http://schemas.xmlsoap.org/rp");
        String prefix = headerElement.getPrefix(namespace, "rp");
        String soapPrefix = headerElement.getPrefix("http://schemas.xmlsoap.org/soap/envelope/");
        Element pathElement = headerElement.addElement(prefix, "path");
        pathElement.setAttribute(soapPrefix, "mustUnderstand", "1");
        pathElement.setAttribute(soapPrefix, "actor", "http://schemas.xmlsoap.org/soap/actor/next");
        String soapAction = request.getMIMEHeader("SOAPAction");
        if (soapAction != null) {
            pathElement.addElement(prefix, "action").setText(Strings.stripQuotes(soapAction));
        } else {
            pathElement.addElement(prefix, "action");
        }
        pathElement.addElement(prefix, "to").setText(this.destination.toString());
        Enumeration fwdPaths = this.proxyContext.getProperties("fwdRoute");
        Element fwd = null;
        if (fwdPaths.hasMoreElements()) {
            fwd = pathElement.addElement(prefix, "fwd");
            while (fwdPaths.hasMoreElements()) {
                fwd.addElement(prefix, "via").setText((String)fwdPaths.nextElement());
            }
        }
        Element rev = pathElement.addElement(prefix, "rev");
        rev.addElement(prefix, "via");
        String from = (String)this.proxyContext.getProperty("clientId");
        if (from != null) {
            pathElement.addElement(prefix, "from").setText(from);
        }
        pathElement.addElement(prefix, "id").setText("uuid:" + new UUID().getKey());
    }
}

