/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security;

import electric.soap.security.encryption.WSSEncryption;
import electric.soap.security.signature.WSSSignature;
import electric.soap.security.tokens.SecurityToken;
import electric.soap.security.util.KeyStoreUtil;
import electric.util.Context;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class WSSContextOut {
    protected Vector securityTokens = new Vector();
    protected Vector signatures = new Vector();
    protected Vector encryptions = new Vector();
    protected Certificate defaultCertificate;
    protected PrivateKey defaultKey;

    public WSSContextOut() {
        this.initDefaultKey();
    }

    protected void initDefaultKey() {
        String name = Context.getSystemProperty("javax.net.ssl.keyStore");
        String password = Context.getSystemProperty("javax.net.ssl.keyStorePassword");
        String type = Context.getSystemProperty("javax.net.ssl.keyStoreType", "JKS");
        if (name == null) {
            return;
        }
        KeyStore defaultStore = null;
        try {
            String alias;
            defaultStore = KeyStoreUtil.loadKeyStoreResource(name, password, type);
            if (defaultStore == null) {
                return;
            }
            Enumeration<String> aliases = defaultStore.aliases();
            while (aliases.hasMoreElements()) {
                alias = aliases.nextElement();
                if (!defaultStore.isCertificateEntry(alias)) continue;
                try {
                    this.defaultCertificate = defaultStore.getCertificate(alias);
                    break;
                }
                catch (KeyStoreException exception) {
                    // empty catch block
                }
            }
            if (this.defaultCertificate == null) {
                return;
            }
            aliases = defaultStore.aliases();
            while (aliases.hasMoreElements()) {
                alias = aliases.nextElement();
                if (!defaultStore.isKeyEntry(alias)) continue;
                try {
                    Key candidateKey = defaultStore.getKey(alias, password.toCharArray());
                    if (candidateKey == null || !(candidateKey instanceof PrivateKey)) break;
                    this.defaultKey = (PrivateKey)candidateKey;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {}
    }

    public void addSecurityToken(SecurityToken token) {
        this.securityTokens.addElement(token);
    }

    public Vector getSecurityTokens() {
        return this.securityTokens;
    }

    public void addSignature(WSSSignature signature) {
        this.signatures.addElement(signature);
    }

    public Vector getSignatures() {
        return this.signatures;
    }

    public void addEncryption(WSSEncryption encryption) {
        this.encryptions.addElement(encryption);
    }

    public Vector getEncryptions() {
        return this.encryptions;
    }
}

