/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.authenticators;

import electric.security.ICredentials;
import electric.security.IRealm;
import electric.soap.security.tokens.UsernameToken;

public class UsernameDigestCredentials
implements ICredentials {
    private UsernameToken token;

    public UsernameDigestCredentials(UsernameToken token) {
        this.token = token;
    }

    public String getUserName() {
        return this.token.getUsername();
    }

    public boolean authenticate(IRealm realm) throws SecurityException {
        String created;
        String password = realm.getPassword(this.getUserName());
        if (password == null) {
            return false;
        }
        String nonce = this.token.getNonce();
        String passwordDigest = UsernameToken.digestPassword(password, nonce, created = this.token.getCreated());
        if (passwordDigest == null) {
            return false;
        }
        if (passwordDigest.equals(this.token.getDigestedPassword())) {
            this.token.setPassword(password);
            return true;
        }
        return false;
    }
}

