/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.authenticators;

import electric.glue.IGLUELoggingConstants;
import electric.security.ICredentials;
import electric.security.IRealm;
import electric.security.credentials.PasswordCredentials;
import electric.soap.SOAPMessage;
import electric.soap.security.IWSSConstants;
import electric.soap.security.RealmPrincipal;
import electric.soap.security.authenticators.IWSSAuthenticator;
import electric.soap.security.authenticators.UsernameDigestCredentials;
import electric.soap.security.tokens.SecurityToken;
import electric.soap.security.tokens.UsernameToken;
import electric.util.log.Log;
import java.util.Vector;

public class UsernameTokenAuthenticator
implements IWSSAuthenticator,
IGLUELoggingConstants,
IWSSConstants {
    private IRealm realm;
    private boolean actAsGuard;

    public UsernameTokenAuthenticator(IRealm realm) {
        this(realm, true);
    }

    public UsernameTokenAuthenticator(IRealm realm, boolean actAsGuard) {
        this.realm = realm;
        this.actAsGuard = actAsGuard;
    }

    public boolean authenticate(SOAPMessage message, Vector tokenList, Vector principalList) {
        boolean authenticated = false;
        int authCount = 0;
        if (this.realm == null) {
            return !this.actAsGuard;
        }
        int i = 0;
        while (i < tokenList.size()) {
            SecurityToken token = (SecurityToken)tokenList.elementAt(i);
            if (token instanceof UsernameToken) {
                UsernameToken usernameToken = (UsernameToken)token;
                authenticated = this.authenticateToken(usernameToken);
                if (authenticated) {
                    RealmPrincipal principal = new RealmPrincipal(this.realm, usernameToken.getUsername());
                    principalList.addElement(principal);
                    ++authCount;
                } else if (this.actAsGuard) {
                    if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                        Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)("username '" + usernameToken.getUsername() + "' not authenticated in realm:" + this.realm.getName()));
                    }
                    return false;
                }
            }
            ++i;
        }
        if (this.actAsGuard && authCount == 0) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"no tokens authenticated, authorization failed");
            }
            return false;
        }
        return true;
    }

    private boolean authenticateToken(UsernameToken userNameToken) {
        boolean authenticated = false;
        String user = userNameToken.getUsername();
        String passwordType = userNameToken.getPasswordType();
        if (passwordType == null) {
            passwordType = "wsse:PasswordText";
        }
        ICredentials credentials = null;
        if (userNameToken.getPasswordType().equals("wsse:PasswordDigest")) {
            credentials = new UsernameDigestCredentials(userNameToken);
        } else {
            String password = userNameToken.getPassword();
            credentials = new PasswordCredentials(user, password);
        }
        authenticated = credentials == null ? false : this.realm.authenticate(credentials);
        return authenticated;
    }
}

