/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.guards;

import electric.glue.IGLUELoggingConstants;
import electric.security.IRealm;
import electric.soap.SOAPMessage;
import electric.soap.security.RealmPrincipal;
import electric.soap.security.guards.IWSSGuard;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.security.Principal;
import java.util.Vector;

public class RoleGuard
implements IWSSGuard,
IGLUELoggingConstants {
    protected IRealm realm;
    protected String[] roles;
    protected boolean allMustAuthorize;

    public RoleGuard(IRealm realm, String role) {
        this(realm, new String[]{role}, true);
    }

    public RoleGuard(IRealm realm, String[] roles) {
        this(realm, roles, true);
    }

    public RoleGuard(IRealm realm, String[] roles, boolean allMustAuthorize) {
        this.realm = realm;
        this.roles = (String[])roles.clone();
        this.allMustAuthorize = allMustAuthorize;
    }

    public boolean authorize(SOAPMessage message, Vector signatures, Vector encryptions, Vector principalList, Vector authorizationCredentials) {
        int authCount = 0;
        if (principalList.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < principalList.size()) {
            Principal principal = (Principal)principalList.elementAt(i);
            if (this.authorizePrincipal(principal)) {
                authorizationCredentials.addElement(principal);
                ++authCount;
            }
            ++i;
        }
        boolean authorized = false;
        if (this.allMustAuthorize) {
            if (authCount == principalList.size()) {
                authorized = true;
            }
        } else if (authCount != 0) {
            authorized = true;
        }
        if (!authorized && Log.isLogging(ILoggingConstants.SECURITY_EVENT)) {
            Log.log(ILoggingConstants.SECURITY_EVENT, (Object)"role authorization failed");
        }
        return authorized;
    }

    private boolean authorizePrincipal(Principal principal) {
        if (principal instanceof RealmPrincipal) {
            RealmPrincipal realmPrincipal = (RealmPrincipal)principal;
            IRealm principalRealm = realmPrincipal.getRealm();
            if (this.realm != principalRealm) {
                return false;
            }
            String user = realmPrincipal.getName();
            if (!this.realm.isUserInRole(user, this.roles)) {
                return false;
            }
        }
        return true;
    }
}

